#! /usr/bin/python

# Generate a sorted list of unicode codepoints used in po files.
# Copyright (C) 2009 Canonical Ltd., written by Colin Watson.
# Based on po2ul.rb:
#   Copyright (C) 2005-2007  Hidetaka Iwai  <tyuyu@debian.or.jp>

import sys
import gettext

def codepoints(fp):
    codes = set()
    translations = gettext.GNUTranslations(fp)
    # Note that _catalog is undocumented.
    for key in translations._catalog.keys():
        if not key:
            continue
        codes.update([ord(c) for c in translations.ugettext(key)])
    return codes

all_codes = set()

if sys.argv[1:]:
    for filename in sys.argv[1:]:
        fp = open(filename)
        all_codes.update(codepoints(fp))
        fp.close()
else:
    all_codes.update(codepoints(sys.stdin))

for code in sorted(all_codes):
    print code
