/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _PROB_F_H_
#define _PROB_F_H_

/*
** $Id: PROB_F.H,v 1.21 2003/02/07 18:04:08 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_INITDATA    initdata
#    define FORT_PROBINIT    probinit
#    define FORT_DENFILL     denfill
#    define FORT_HYPFILL     hypfill
#    define FORT_XMOMFILL    xmomfill
#    define FORT_YMOMFILL    ymomfill
#    define FORT_ZMOMFILL    zmomfill
#    define FORT_EDENFILL    edenfill
#    define FORT_CHEMFILL    chemfill
#    define FORT_ALLCHEMFILL allchemfill
#    define FORT_TRACFILL    tracfill
#    define FORT_DENERROR    denerror
#    define FORT_TRCERROR    trcerror
#  ifdef BL_USE_CHEM
#    define FORT_SETCOMPS    setcomps
#    define FORT_MIB_CHEM    mibchem
#    define FORT_FINIT       finit
#  endif
#  ifdef BL_SYNC_RANTABLES
#    define FORT_SYNC_RANTABLES    syncrantables
#  endif
#  ifdef BL_BS_HOLEINTOP
#    define FORT_GETHOLEPARAMS  getholeparams
#  endif
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_INITDATA    INITDATA
#    define FORT_PROBINIT    PROBINIT
#    define FORT_DENFILL     DENFILL
#    define FORT_HYPFILL     HYPFILL
#    define FORT_XMOMFILL    XMOMFILL
#    define FORT_YMOMFILL    YMOMFILL
#    define FORT_ZMOMFILL    ZMOMFILL
#    define FORT_EDENFILL    EDENFILL
#    define FORT_CHEMFILL    CHEMFILL
#    define FORT_ALLCHEMFILL ALLCHEMFILL
#    define FORT_TRACFILL    TRACFILL
#    define FORT_DENERROR    DENERROR
#    define FORT_TRCERROR    TRCERROR
#  ifdef BL_USE_CHEM
#    define FORT_SETCOMPS    SETCOMPS
#    define FORT_MIB_CHEM    MIBCHEM
#    define FORT_FINIT       FINIT
#  endif
#  ifdef BL_SYNC_RANTABLES
#    define FORT_SYNC_RANTABLES    SYNCRANTABLES
#  endif
#  ifdef BL_BS_HOLEINTOP
#    define FORT_GETHOLEPARAMS  GETHOLEPARAMS
#  endif
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_INITDATA    initdata
#    define FORT_PROBINIT    probinit
#    define FORT_DENFILL     denfill
#    define FORT_HYPFILL     hypfill
#    define FORT_XMOMFILL    xmomfill
#    define FORT_YMOMFILL    ymomfill
#    define FORT_ZMOMFILL    zmomfill
#    define FORT_EDENFILL    edenfill
#    define FORT_CHEMFILL    chemfill
#    define FORT_ALLCHEMFILL allchemfill
#    define FORT_TRACFILL    tracfill
#    define FORT_DENERROR    denerror
#    define FORT_TRCERROR    trcerror
#  ifdef BL_USE_CHEM
#    define FORT_SETCOMPS    setcomps
#    define FORT_MIB_CHEM    mibchem
#    define FORT_FINIT       finit
#  endif
#  ifdef BL_SYNC_RANTABLES
#    define FORT_SYNC_RANTABLES    syncrantables
#  endif
#  ifdef BL_BS_HOLEINTOP
#    define FORT_GETHOLEPARAMS  getholeparams
#  endif
#  else
#    define FORT_INITDATA    initdata_
#    define FORT_PROBINIT    probinit_
#    define FORT_DENFILL     denfill_
#    define FORT_HYPFILL     hypfill_
#    define FORT_XMOMFILL    xmomfill_
#    define FORT_YMOMFILL    ymomfill_
#    define FORT_ZMOMFILL    zmomfill_
#    define FORT_EDENFILL    edenfill_
#    define FORT_CHEMFILL    chemfill_
#    define FORT_ALLCHEMFILL allchemfill_
#    define FORT_TRACFILL    tracfill_
#    define FORT_DENERROR    denerror_
#    define FORT_TRCERROR    trcerror_
#  ifdef BL_USE_CHEM
#    define FORT_SETCOMPS    setcomps_
#    define FORT_MIB_CHEM    mibchem_
#    define FORT_FINIT       finit_
#  endif
#  ifdef BL_SYNC_RANTABLES
#    define FORT_SYNC_RANTABLES    syncrantables_
#  endif
#  ifdef BL_BS_HOLEINTOP
#    define FORT_GETHOLEPARAMS  getholeparams_
#  endif
#  endif
#  endif

#include "ArrayLim.H"

extern "C"
{
     void FORT_PROBINIT (const int* init,
                         const int* name,
                         const int* namelen,
                         const Real* problo,
                         const Real* probhi);

#ifdef BL_SYNC_RANTABLES
     void FORT_SYNC_RANTABLES (Real *RanPhaseTable,
                               Real *RanAmplTable,
                               const int* igetput);
#endif

#ifdef BL_BS_HOLEINTOP
     void FORT_GETHOLEPARAMS (Real *xholeloc,
                              Real *yholeloc,
                              Real *rhole);
#endif

#ifdef BL_EXPLOSION_INIT
     void FORT_INITDATA (const int* level, const Real* time,
                         const int* lo,const int* hi,
                         const int* nscal, Real* scal,
                         ARLIM_P(lo), ARLIM_P(hi),
                         const int* nblastinit, Real* blastinit,
                         ARLIM_P(blastlo), ARLIM_P(blasthi),
                         const Real* dx,
                         const Real* xlo, const Real* xhi);
#else
     void FORT_INITDATA (const int* level, const Real* time,
                         const int* lo,const int* hi,
                         const int* nscal, Real* scal,
                         ARLIM_P(lo), ARLIM_P(hi),
                         const Real* dx,
                         const Real* xlo, const Real* xhi);
#endif

     void FORT_DENFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_HYPFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_XMOMFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                          const int* dom_lo, const int* dom_hi,
                          const Real* dx, const Real* grd_lo,
                          const Real* time, const int* bc);

     void FORT_YMOMFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_ZMOMFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_EDENFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                          const int* dom_lo, const int* dom_hi,
                          const Real* dx, const Real* grd_lo,
                          const Real* time, const int* bc);

     void FORT_CHEMFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                          const int* dom_lo, const int* dom_hi,
                          const Real* dx, const Real* grd_lo,
                          const Real* time, const int* bc,
                          const int* stateID);

     void FORT_ALLCHEMFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                             const int* dom_lo, const int* dom_hi,
                             const Real* dx, const Real* grd_lo,
                             const Real* time, const int* bc);

     void FORT_TRACFILL  (Real* data, ARLIM_P(lo), ARLIM_P(hi),
                          const int* dom_lo, const int* dom_hi,
                          const Real* dx, const Real* grd_lo,
                          const Real* time, const int* bc);

     void FORT_DENERROR  (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                          const int* tagval, const int* clearval,
                          Real* data, ARLIM_P(dlo), ARLIM_P(dhi),
                          const int* lo, const int* hi, const int* nvar,
                          const int* domain_lo, const int* domain_hi,
                          const Real* dx, const Real* xlo,
                          const Real* prob_lo, const Real* time,
                          const int* level);

     void FORT_TRCERROR  (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                          const int* tagval, const int* clearval,
                          Real* data, ARLIM_P(dlo), ARLIM_P(dhi),
                          const int* lo, const int* hi, const int* nvar,
                          const int* domain_lo, const int* domain_hi,
                          const Real* dx, const Real* xlo,
                          const Real* prob_lo, const Real* time,
                          const int* level);

#ifdef BL_USE_CHEM
     void FORT_SETCOMPS (const int* rho,  const int* Xmom, const int* Ymom,
                         const int* Zmom, const int* Eden, const int* FirstSpec,
                         const int* Tracer);

     void FORT_MIB_CHEM(const int* lo, const int* hi,
                        Real* s, ARLIM_P(slo), ARLIM_P(shi));

     void FORT_FINIT(const int* lo, const int* hi,
                        Real* s, ARLIM_P(slo), ARLIM_P(shi),Real* dt);
#endif
}
#endif

#endif /*_PROB_F_H_*/
