#
#
#!/usr/bin/ruby

# ====================================================================
# ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
# ====================================================================
# 
#    Project              : SagCAD
#    Description          : Script
#    Source               : diagram.rb
# 
#    ----------------------------------
# 
#    License              : GNU General Public License (GPL)
#    Copyright            : (C) 1998-2003 by Yutaka Sagiya
#    email                : kappa@a6s.highway.ne.jp
#                         : yutaka@sagiya.com
#    Begin                : 2003/05/21
#    Last                 : 2003/05/21
# ====================================================================

include Math



# ----------------------------------------------------------
# $num ľܓď_ȉ nɂ
# ----------------------------------------------------------
def sg(value, n)
	sgn = (value.to_f * 10**n.to_f).round
	ret = sgn.to_f / (10**n.to_f)
	return ret
end



# Βl
def abs(dbl)
	if dbl < 0 then 
		return dbl = dbl * (-1.0)
	end
	return dbl
end



# -------------------------------------------------------------------
# px̒PʂAx (DEG) 烉WA (RAD) ɕϊB
# x  RAD
# 
#  : value : px (Deg)
# ߒl : px (Rad)
def degrad(value)
	return (value * (PI / 180))
end



# -------------------------------------------------------------------
# px̒PʂAWA (RAD) x (DEG) x (DEG) ɕϊB
# RAD  x
# 
#  : value : px (Rad)
# ߒl : px (Deg)
def raddeg(value)
	return ((180 / PI) * value)
end



class Diagram

	PI = 3.14159265358979
	CALCU_DIGITS = 10
	COMPA_DIGITS = 3

	attr_accessor :Type
	attr_accessor :Angle
	attr_accessor :Length
	attr_accessor :Value
	attr_accessor :sx
	attr_accessor :sy
	attr_accessor :ex
	attr_accessor :ey
	attr_accessor :cx
	attr_accessor :cy
	attr_accessor :r


	# ----------------------------------
	# 
	# 
	# Diagram = Diagram.new ŌĂяo
	# ----------------------------------
	def initialize
		@Type = 0
		@Angle = 0.0
		@Length = 0.0
		@Value = 0
		@sx = [0.0, 0.0, 0.0, 0.0, 0.0]
		@sy = [0.0, 0.0, 0.0, 0.0, 0.0]
		@ex = [0.0, 0.0, 0.0, 0.0, 0.0]
		@ey = [0.0, 0.0, 0.0, 0.0, 0.0]
		@cx = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
		@cy = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
		@r  = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
	end





	# --------------------------------------------------------------------------
	# 
	# 

	# ----------------------------------------------------------------
	# n_ƏI_Ԑ sx[2] : ex[2] 
	# _߂
	# ppp
	#  : 
	#      :    n_    (@sx[1] , @sy[1])
	#      :    I_    (@ex[1] , @ey[1])
	#      :          (@sx[2] , @ex[2])
	# ߒl : return : 1
	#      :    _      (@sx[3] , @sy[3])
	def ppp()
		@sx[3] = ((@sx[2]) * (@ex[1]) + (@ex[2]) * (@sx[1])) / ((@sx[2]) + (@ex[2]))
		@sy[3] = ((@sx[2]) * (@ey[1]) + (@ex[2]) * (@sy[1])) / ((@sx[2]) + (@ex[2]))
		return 1
	end



	# ----------------------------------------------------------------
	# ̊px
	# la
	#  : 
	#      :          (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	# ߒl : return : 1
	#      :    px    @Angle
	def la()
		dx = @ex[1] - @sx[1]
		dy = @ey[1] - @sy[1]
		dx = sg(dx, CALCU_DIGITS)
		dy = sg(dy, CALCU_DIGITS)

		# X ړAY+ ړ  XOx
		if (dx == 0 && dy > 0)
			@Angle = 90
			@Type = 1

		# X ړAY- ړ  QVOx
		elsif (dx == 0 && dy < 0)
			@Angle = 270
			@Type = 1

		# X+ ړAY ړ  Ox
		elsif (dx > 0 && dy == 0)
			@Angle = 0
			@Type = 1

		# X- ړAY ړ  PWOx
		elsif (dx < 0 && dy == 0)
			@Angle = 180
			@Type = 1

		# X ړAY ړ
		elsif (dx == 0 && dy == 0)
			# msg "ړL܂"
			@Type = 0

		else
			@Angle = Math::atan2(abs(dy) , abs(dx))
			@Angle = raddeg(@Angle)
			
			if (dx < 0 && dy > 0)
				@Angle = 180 - @Angle
			end
			if (dx < 0 && dy < 0)
				@Angle = 180 + @Angle
			end
			if (dx > 0 && dy < 0)
				@Angle = 360 - @Angle
			end
			if (@Angle < 0)
				@Angle = @Angle + 360
			end
			if (@Angle >= 360)
				@Angle = @Angle - 360
			end
			@Type = 1
		end
		return 0
	end



	# ----------------------------------------------------------------
	# n_ƊpxƋŒ̏I_߂
	# pap
	#  : 
	#      : n_   (@sx[1] , @sy[1])
	#      : px   @Angle
	#      :    @Length
	# ߒl : 
	#      : _     (@ex[1] , @ey[1])
	def pap()
		if ((@Angle) < 0)
			@Angle = 360 + (@Angle)
		end

		@Angle = degrad(@Angle)
		@ex[1] = (@sx[1]) + (@Length)*Math::cos(@Angle)
		@ey[1] = (@sy[1]) + (@Length)*Math::sin(@Angle)

		return 1
	end



	# ----------------------------------------------------------------
	# Q_Ԃ̋
	# pp
	#  : 
	#      : _ 1 (sx[1] , sy[1])
	#      : _ 2 (ex[1] , ey[1])
	# ߒl : 
	#      : Length
	def pp()

		@Length = sqrt(((@ex[1] - @sx[1]) * (@ex[1] - @sx[1])) + ((@ey[1] - @sy[1]) * (@ey[1] - @sy[1])))
		@Type = 1

		return 1
	end



	# ----------------------------------------------------------------
	# ɒ钼̊px
	# lla
	#  : 
	#      :      (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	# ߒl : 
	#      : px    @Angle
	def lla()

		diagram_la = Diagram.new

		diagram_la.sx[1] = @sx[1]
		diagram_la.sy[1] = @sy[1]
		diagram_la.ex[1] = @ex[1]
		diagram_la.ey[1] = @ey[1]
		diagram_la.la
		@Angle = diagram_la.Angle
		@Angle = (@Angle) + 90.0

		if ((@Angle) < 0.0)
			@Angle = (@Angle) + 360.0
		elsif ((@Angle) >= 360.0)
			@Angle = (@Angle) - 360.0
		end
		return 1
	end



		# -------------------------------------------------------------------
		# n_ƏI_^̃ItZbg
		# lo
		#  : 
		#      :     (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
		#      :    @Length
		# ߒl : 
		#      :     (@sx[2] , @sy[2]) - (@ex[2] , @ey[2]) is  
		#      :     (@sx[3] , @sy[3]) - (@ex[3] , @ey[3]) is  E
		def lo()

			diagram_lla = Diagram.new
			diagram_pap = Diagram.new

			# ɒ钼̊px
			diagram_lla.sx[1] = @sx[1]
			diagram_lla.sy[1] = @sy[1]
			diagram_lla.ex[1] = @ex[1]
			diagram_lla.ey[1] = @ey[1]
			diagram_lla.lla

			# n_I_̂ꂼn_ƂLLAŋ߂px
			# ItZbg̋ꂽ_߂B
			# isɃItZbg
			# 
			diagram_pap.sx[1] = @sx[1]
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_lla.Angle
			diagram_pap.Length = @Length
			diagram_pap.pap
			@sx[2] = diagram_pap.ex[1]
			@sy[2] = diagram_pap.ey[1]

			diagram_pap.sx[1] = @ex[1] 
			diagram_pap.sy[1] = @ey[1] 
			diagram_pap.Angle = diagram_lla.Angle 
			diagram_pap.Length = @Length
			diagram_pap.pap
			@ex[2] = diagram_pap.ex[1] 
			@ey[2] = diagram_pap.ey[1]

			# PWOx]̃ItZbg
			# isEɃItZbg
			# ɒ钼̊px
			diagram_lla.sx[1] = @ex[1]
			diagram_lla.sy[1] = @ey[1]
			diagram_lla.ex[1] = @sx[1]
			diagram_lla.ey[1] = @sy[1]
			diagram_lla.lla

			diagram_pap.sx[1] = @sx[1]
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_lla.Angle 
			diagram_pap.Length = @Length
			diagram_pap.pap
			@sx[3] = diagram_pap.ex[1]
			@sy[3] = diagram_pap.ey[1]

			diagram_pap.sx[1] = @ex[1]
			diagram_pap.sy[1] = @ey[1]
			diagram_pap.Angle = diagram_lla.Angle 
			diagram_pap.Length = @Length
			diagram_pap.pap
			@ex[3] = diagram_pap.ex[1]
			@ey[3] = diagram_pap.ey[1]

			return 1
		end



	# -------------------------------------------------------------------
	# Q̌_
	# llp
	#  : 
	#      : 1   (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : 2   (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
	# ߒl : 
	#      : @Type = 1:I   0:G[
	#      : _  (@sx[3] , @sy[3])
	def llp()

		# PŁAQ̂Ƃ
		if (sg(@sx[1], COMPA_DIGITS) == sg(@ex[1], COMPA_DIGITS) && sg(@sy[2], COMPA_DIGITS) == sg(@ey[2], COMPA_DIGITS)) 
			@sx[3] = sg(@sx[1], CALCU_DIGITS)
			@sy[3] = sg(@sy[2], CALCU_DIGITS)
			@Type = 1
			return 1
		end

		# QŁAP̂Ƃ
		if (sg(@sx[2], COMPA_DIGITS) == sg(@ex[2], COMPA_DIGITS) && sg(@sy[1], COMPA_DIGITS) == sg(@ey[1], COMPA_DIGITS)) 
			@sx[3] = sg(@sx[2], CALCU_DIGITS)
			@sy[3] = sg(@sy[1], CALCU_DIGITS)
			@Type = 1
			return 1
		end

		# PAXOxŐQ΂ߐ̂Ƃ
		if (sg(@ex[1] - @sx[1], COMPA_DIGITS) == 0 && sg(@ex[2] - @sx[2], COMPA_DIGITS) != 0) 
			a2 = (@ey[2] - @sy[2]) / (@ex[2] - @sx[2])
			b2 = @sy[2] - a2 * @sx[2]
			@sx[3] = @sx[1]
			@sy[3] = a2 * @sx[3] + b2
			@Type = 1
		end

		# QƂxɕŝƂ
		if (sg(@ex[1] - @sx[1], COMPA_DIGITS) == 0 && sg(@ex[2] - @sx[2], COMPA_DIGITS) == 0) 
			@Type = 0
			return 0
		end

		# QAXOxŐP΂ߐ̂Ƃ
		if (sg(@ex[2] - @sx[2], COMPA_DIGITS) == 0 && sg(@ex[1] - @sx[1], COMPA_DIGITS) != 0) 
			a1 = (@ey[1] - @sy[1]) / (@ex[1] - @sx[1])
			b1 = @sy[1] - a1 * @sx[1]
			@sx[3] = @sx[2]
			@sy[3] = a1 * @sx[3] + b1
			@Type = 1
		end

		# PQA΂ߐ܂́ÂƂ
		if (sg(@ex[1] - @sx[1], COMPA_DIGITS) != 0 && sg(@ex[2] - @sx[2], COMPA_DIGITS) != 0) 
			a1 = (@ey[1] - @sy[1]) / (@ex[1] - @sx[1])
			a2 = (@ey[2] - @sy[2]) / (@ex[2] - @sx[2])
			b1 = @sy[1] - a1 * @sx[1]
			b2 = @sy[2] - a2 * @sx[2]
			if (a1 - a2 != 0) 
				@sx[3] = (b2 - b1) / (a1 - a2)
				@sy[3] = a1 * @sx[3] + b1
				@Type = 1
			elsif (a1 - a2 == 0) 
				# Qs
				@Type = 0
				return 0
			end
		end
		return 1
	end



	# ----------------------------------------------------------
	# _ƒ̍ŋߓ_iP_ʂ鐂j
	# plp
	#  : 
	#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : _ 1    (@sx[2] , @sy[2])
	# ߒl : 
	#      : @Type    0 , 1
	#      : _ 1    (@ex[2] , @ey[2])
	#      : _ 2    (@ex[3] , @ey[3]) _Ɗ֌WȂ_
	def plp()

		diagram_lla = Diagram.new
		diagram_pap = Diagram.new
		diagram_llp = Diagram.new


		# ɒ钼̊px߂B
		diagram_lla.sx[1] = @sx[1]
		diagram_lla.sy[1] = @sy[1]
		diagram_lla.ex[1] = @ex[1]
		diagram_lla.ey[1] = @ey[1]
		diagram_lla.lla
		# @ANGLE = diagram_lla.ANGLE
		
		# n_iP_jƊpxƋ[1]Œ̏I_߂B
		diagram_pap.sx[1] = @sx[2]
		diagram_pap.sy[1] = @sy[2]
		diagram_pap.Angle = diagram_lla.Angle
		diagram_pap.Length = 100
		diagram_pap.pap
		
		# Q̌_
		diagram_llp.sx[1] = @sx[1]
		diagram_llp.sy[1] = @sy[1]
		diagram_llp.ex[1] = @ex[1]
		diagram_llp.ey[1] = @ey[1]
		diagram_llp.ex[2] = @sx[2]
		diagram_llp.ey[2] = @sy[2]
		diagram_llp.sx[2] = diagram_pap.ex[1]
		diagram_llp.sy[2] = diagram_pap.ey[1]
		diagram_llp.llp
		
		@ex[2] = diagram_llp.sx[3]
		@ey[2] = diagram_llp.sy[3]
		@ex[3] = diagram_pap.ex[1]
		@ey[3] = diagram_pap.ey[1]
		@Type = 1

		return 1
	end





	# -------------------------------------------------------------------
	# Ɖ~̌_
	# lcp
	#  : 
	#      :  1  (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : ~ 1  (@cx[1] , @cy[1]) , @r[1]
	# ߒl : 
	#      : @Type   0 , 1 , 2
	#      : _ 1  (@sx[2] , @sy[2])
	#      : _ 2  (@sx[3] , @sy[3])
	def lcp()
		diagram_plp = Diagram.new
		diagram_pp = Diagram.new

		lcptype = 0

		# Ɖ~̒SƂ̋߂
		diagram_plp.sx[2] = @cx[1]
		diagram_plp.sy[2] = @cy[1]
		diagram_plp.sx[1] = @sx[1]
		diagram_plp.sy[1] = @sy[1]
		diagram_plp.ex[1] = @ex[1]
		diagram_plp.ey[1] = @ey[1]
		diagram_plp.plp

		# Q_Ԃ̋
		diagram_pp.sx[1] = @cx[1]
		diagram_pp.sy[1] = @cy[1]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp

		disp = diagram_pp.Length
		r1 = @r[1]

	#	print "lcp() : disp = ",disp,"\n"
	#	print "lcp() : r1 = ",r1,"\n"
	#	print "lcp() : COMPA_DIGITS = ",COMPA_DIGITS,"\n"
	#	print "lcp() : digits = ",(1/(10**COMPA_DIGITS.to_f)),"\n"

		# -----------------------------------------------------
		# ~ƒ̈ʒu֌Wƌ_
		#


		# -----------------------------------------------------
		# ڂĂ 
		# 
		if (disp + (1/(10**COMPA_DIGITS.to_f)) > r1 && disp - (1/(10**COMPA_DIGITS.to_f)) < r1) 
	#		print "lcp : ڂĂ 1\n"
			@Type = 1
			@sx[2] = diagram_plp.ex[2]
			@sy[2] = diagram_plp.ey[2]



		# -----------------------------------------------------
		# dȂĂ
		# 
		elsif (sg(disp, COMPA_DIGITS) < sg(r1, COMPA_DIGITS)) 
	#		print "lcp : dȂĂ 2\n"
			@Type = 2
			# ꂪ0ɂȂƃG[ƂȂ邽XWYWvZɓꊷB
			if (sg((@ex[1] - @sx[1]), COMPA_DIGITS) == 0) 
				f_dumy = @sx[1]
				@sx[1] = @sy[1]
				@sy[1] = f_dumy
				f_dumy = @ex[1]
				@ex[1] = @ey[1]
				@ey[1] = f_dumy
				f_dumy = @cx[1]
				@cx[1] = @cy[1]
				@cy[1] = f_dumy
				lcptype = 1
			end

			mm = (@ey[1] - @sy[1]) / (@ex[1] - @sx[1])
			nn = @sy[1] - mm * @sx[1]
			aa1 = (mm * mm + 1)
			bb = 2 * (mm * nn - @cx[1] - @cy[1] * mm)
			cc = @cx[1] * @cx[1] - @r[1] * @r[1] + (nn - @cy[1]) * (nn - @cy[1])
			dd = bb * bb - aa1 * aa1 * cc

			@sx[2] = (-bb - sqrt(bb * bb - 4 * aa1 * cc)) / (2 * aa1)
			@sy[2] = mm * @sx[2] + nn
			@sx[3] = (-bb + sqrt(bb * bb - 4 * aa1 * cc)) / (2 * aa1)
			@sy[3] = mm * @sx[3] + nn

			# X WY Wꊷ̂ɖ߂B
			if (lcptype == 1) 
				f_dumy = @sx[1]
				@sx[1] = @sy[1]
				@sy[1] = f_dumy
				f_dumy = @ex[1]
				@ex[1] = @ey[1]
				@ey[1] = f_dumy
				f_dumy = @cx[1]
				@cx[1] = @cy[1]
				@cy[1] = f_dumy
				f_dumy = @sx[2]
				@sx[2] = @sy[2]
				@sy[2] = f_dumy
				f_dumy = @sx[3]
				@sx[3] = @sy[3]
				@sy[3] = f_dumy
				lcptype = 0
			end



		# -----------------------------------------------------
		# Ă
		# 
		elsif (sg(disp, COMPA_DIGITS) > sg(r1, COMPA_DIGITS)) 
	#		print "lcp : Ă 0\n"
			@Type = 0
			return 0
		end

		print "lcp : G[ 0\n"
		return 0
	end





	# -------------------------------------------------------------------
	# Q~̌_
	# ccp
	#  : 
	#      : ~ 1      (@cx[1] , @cy[1]) , @r[1]
	#      : ~ 2      (@cx[2] , @cy[2]) , @r[2]
	# ߒl : 
	#      : @Type       0 , 1 , 2
	#      : _ 1    (@sx[1] , @sy[1])
	#      : _ 2    (@sx[2] , @sy[2])
	def ccp()

		diagram_rtn = Diagram.new
		diagram_pp = Diagram.new
		diagram_la = Diagram.new
		diagram_pap = Diagram.new
		diagram_lcp = Diagram.new
		diagram_lla = Diagram.new


		# ~1̕傫Ȃ悤Ƀf[^ꂩ
		if (@r[1] < @r[2]) 
			diagram_rtn.cx[1] = @cx[2]
			diagram_rtn.cy[1] = @cy[2]
			diagram_rtn.r[1] = @r[2]

			diagram_rtn.cx[2] = @cx[1]
			diagram_rtn.cy[2] = @cy[1]
			diagram_rtn.r[2] = @r[1]

			@cx[1] = diagram_rtn.cx[1]
			@cy[1] = diagram_rtn.cy[1]
			@r[1] = diagram_rtn.r[1]

			@cx[2] = diagram_rtn.cx[2]
			@cy[2] = diagram_rtn.cy[2]
			@r[2] = diagram_rtn.r[2]
		end

		# QS̋
		diagram_pp.sx[1] = @cx[1]
		diagram_pp.sy[1] = @cy[1]
		diagram_pp.ex[1] = @cx[2]
		diagram_pp.ey[1] = @cy[2]
		diagram_pp.pp

		# Q~̈ʒu֌Wƌ_
		dist = diagram_pp.Length
		# R1 + R2
		r1pr2 = @r[1] + @r[2]
		# R1 - R2
		r1mr2 = @r[1] - @r[2]



		# -----------------------------------------------------
		# _ 1  
		# 
		if (sg(dist, COMPA_DIGITS) == sg(r1pr2, COMPA_DIGITS) || sg(dist, COMPA_DIGITS) == sg(r1mr2, COMPA_DIGITS)) 
			@Type = 1
			diagram_la.sx[1] = @cx[1]
			diagram_la.sy[1] = @cy[1]
			diagram_la.ex[1] = @cx[2]
			diagram_la.ey[1] = @cy[2]
			diagram_la.la

			diagram_pap.sx[1] = @cx[1]
			diagram_pap.sy[1] = @cy[1]
			diagram_pap.Angle = diagram_la.Angle
			diagram_pap.Length = @r[1]
			diagram_pap.pap

			@sx[1] = diagram_pap.ex[1]
			@sy[1] = diagram_pap.ey[1]
			@sx[2] = 0
			@sy[2] = 0



		# -----------------------------------------------------
		# _2
		# 
		elsif (sg(dist, COMPA_DIGITS) < sg(r1pr2, COMPA_DIGITS) && sg(dist, COMPA_DIGITS) > sg(r1mr2, COMPA_DIGITS)) 
			@Type = 2
			p = ((@r[1] * @r[1]) - (@r[2] * @r[2]) + (diagram_pp.Length * diagram_pp.Length)) / (2 * diagram_pp.Length)
			# LA ̊px
			diagram_la.sx[1] = @cx[1]
			diagram_la.sy[1] = @cy[1]
			diagram_la.ex[1] = @cx[2]
			diagram_la.ey[1] = @cy[2]
			diagram_la.la

			# PAP n_ƊpxƋŒ̏I_߂
			diagram_pap.sx[1] = @cx[1]
			diagram_pap.sy[1] = @cy[1]
			diagram_pap.Angle = diagram_la.Angle
			diagram_pap.Length = p
			diagram_pap.pap

			# LLA ɒ钼̊px
			diagram_lla.sx[1] = @cx[1]
			diagram_lla.sy[1] = @cy[1]
			diagram_lla.ex[1] = @cx[2]
			diagram_lla.ey[1] = @cy[2]
			diagram_lla.lla

			# PAP n_ƊpxƋŒ̏I_߂
			diagram_pap.sx[1] = diagram_pap.ex[1]
			diagram_pap.sy[1] = diagram_pap.ey[1]
			diagram_pap.Angle = diagram_lla.Angle
			diagram_pap.Length = 10
			diagram_pap.pap

			# LCP Ɖ~̌_
			diagram_lcp.sx[1] = diagram_pap.sx[1]
			diagram_lcp.sy[1] = diagram_pap.sy[1]
			diagram_lcp.ex[1] = diagram_pap.ex[1]
			diagram_lcp.ey[1] = diagram_pap.ey[1]
			diagram_lcp.cx[1] = @cx[1]
			diagram_lcp.cy[1] = @cy[1]
			diagram_lcp.r[1] = @r[1]
			diagram_lcp.lcp

			@sx[1] = diagram_lcp.sx[2]
			@sy[1] = diagram_lcp.sy[2]
			@sx[2] = diagram_lcp.sx[3]
			@sy[2] = diagram_lcp.sy[3]



		# -----------------------------------------------------
		# _ 0  
		# 
		else 
	#	else if ((dist > r1pr2) || (dist < r1mr2 && dist > 0)) {
			@Type = 0
			return 0
		end

		return 1
	end



	# -------------------------------------------------------------------
	# P_ʂ~ɐڂ钼̏I_
	# pcl
	#  : 
	#      : _      (@sx[1] , @sy[1])
	#      : ~      (@cx[1] , @cy[1]) , @r[1]
	# ߒl : 
	#      : @Type    0 , 1 , 21])
	#      : _ 1    (@ex[1] , @ey[1])
	#      : _ 2    (@ex[2] , @ey[2])
	def pcl()

		diagram_rtn = Diagram.new
		diagram_pp = Diagram.new
		diagram_la = Diagram.new
		diagram_lla = Diagram.new
		diagram_pap = Diagram.new
		diagram_ccp = Diagram.new


		# Q_Ԃ̋
		diagram_pp.sx[1] = @sx[1]
		diagram_pp.sy[1] = @sy[1]
		diagram_pp.ex[1] = @cx[1]
		diagram_pp.ey[1] = @cy[1]
		diagram_pp.pp

		if (sg(diagram_pp.Length, COMPA_DIGITS) < sg(@r[1], COMPA_DIGITS)) 
			@Type = 0
			return 1
		end

		if (sg(diagram_pp.Length, COMPA_DIGITS) == sg(@r[1], COMPA_DIGITS)) 
			# _~ɂ邩A_Ɖ~̒SԐɐœ_ʂ
			# LLA	 ɒ钼̊px
			diagram_lla.sx[1] = @sx[1]
			diagram_lla.sy[1] = @sy[1]
			diagram_lla.ex[1] = @cx[1]
			diagram_lla.ey[1] = @cy[1]
			diagram_lla.lla
			
			# PAP	n_ƊpxƋŒ̏I_߂
			diagram_pap.sx[1] = @sx[1]
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_lla.Angle
			diagram_pap.Length = 100
			diagram_pap.pap
			
			@Type = 1
			@sx[1] = diagram_pap.sx[1]
			@sy[1] = diagram_pap.sy[1]
			@ex[1] = diagram_pap.ex[1]
			@ey[1] = diagram_pap.ey[1]
			
			return 0
		end

		if (sg(diagram_pp.Length, COMPA_DIGITS) > sg(@r[1], COMPA_DIGITS)) 
			# S_ԐP̋@diagram_pp.Length */
			# LA	̊px */
			diagram_la.sx[1] = @sx[1]
			diagram_la.sy[1] = @sy[1]
			diagram_la.ex[1] = @cx[1]
			diagram_la.ey[1] = @cy[1]
			diagram_la.la
			
			# PAP	n_ƊpxƋŒ̏I_߂ */
			diagram_pap.sx[1] = @sx[1]
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_la.Angle
			diagram_pap.Length = diagram_pp.Length / 2
			diagram_pap.pap
			
			# CCP	Q~̌_ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1]
			diagram_ccp.cx[2] = diagram_pap.ex[1]
			diagram_ccp.cy[2] = diagram_pap.ey[1]
			diagram_ccp.r[2] = diagram_pp.Length / 2
			diagram_ccp.ccp
			
			@Type = 2
			@ex[1] = diagram_ccp.sx[1]
			@ey[1] = diagram_ccp.sy[1]
			@ex[2] = diagram_ccp.sx[2]
			@ey[2] = diagram_ccp.sy[2]
			
			return 0
		end
		return 1
	end



	# -------------------------------------------------------------------
	# Q~ɐڂ钼
	# ccl
	#  : 
	#      : ~ 1    (@cx[1] , @cy[1]) ,@r[1]
	#      : ~ 2    (@cx[2] , @cy[2]) ,@r[2]
	# ߒl : 
	#      : @Type    0, 1 , 2 , 3 , 4
	#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      :  2    (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
	#      :  3    (@sx[3] , @sy[3]) - (@ex[3] , @ey[3])
	#      :  4    (@sx[4] , @sy[4]) - (@ex[4] , @ey[4])
	def ccl()

		diagram_pp = Diagram.new
		diagram_pp2 = Diagram.new
		diagram_ppp = Diagram.new
		diagram_la = Diagram.new
		diagram_la2 = Diagram.new
		diagram_pap = Diagram.new
		diagram_pap2 = Diagram.new
		diagram_plp = Diagram.new
		diagram_lcp = Diagram.new


		ccltype = 0
		diagram_pp.sx[1] = @cx[1]
		diagram_pp.sy[1] = @cy[1]
		diagram_pp.ex[1] = @cx[2]
		diagram_pp.ey[1] = @cy[2]
		diagram_pp.pp

		dist = sg(diagram_pp.Length, COMPA_DIGITS)
		r1pr2 = sg((@r[1] + @r[2]), COMPA_DIGITS)
		r1mr2 = sg((@r[1] - @r[2]), COMPA_DIGITS)


	#	print "dist = ",dist,"\n"
	#	print "r1pr2 = ",r1pr2,"\n"
	#	print "r1mr2 = ",r1mr2,"\n"


		# Q~ĂBڐS{ */
		if (dist > r1pr2) 
	#		print "Q~ĂBڐS{\n"
			@Type = 4
			
			# ڂ钼 */

			# O1(dumy.cx[1],dumy.cy[1]) - O2(dumy.cx[2],dumy.cy[2])  */
			# dumy.r[1] : dumy.r[2] ɓ_ P ߂B */
			diagram_ppp.sx[1] = @cx[1]
			diagram_ppp.sy[1] = @cy[1]
			diagram_ppp.ex[1] = @cx[2]
			diagram_ppp.ey[1] = @cy[2]
			diagram_ppp.sx[2] = @r[1]
			diagram_ppp.ex[2] = @r[2]
			diagram_ppp.ppp

			# O1(dumy.cx[1] , dumy.cy[1]) _ P (pph.sx[3] , pph.sy[3]) ̊px߂B */
			diagram_la2.sx[1] = @cx[1]
			diagram_la2.sy[1] = @cy[1]
			diagram_la2.ex[1] = diagram_ppp.sx[3]
			diagram_la2.ey[1] = diagram_ppp.sy[3]
			diagram_la2.la

			# O1(dumy.cx[1] , dumy.cy[1]) _ P (pph.sx[3] , pph.sy[3]) ̋߂B */
			diagram_pp2.sx[1] = @cx[1]
			diagram_pp2.sy[1] = @cy[1]
			diagram_pp2.ex[1] = diagram_ppp.sx[3]
			diagram_pp2.ey[1] = diagram_ppp.sy[3]
			diagram_pp2.pp
			
			x = @r[1] / diagram_pp2.Length
			x = atan(x / sqrt(-x * x + 1))
			x = (180 / PI) * x
			
			x1 = diagram_la2.Angle + x
			x2 = diagram_la2.Angle - x

			# _ P px x1 ̐ */
			diagram_pap2.sx[1] = diagram_ppp.sx[3]
			diagram_pap2.sy[1] = diagram_ppp.sy[3]
			diagram_pap2.Angle = x1
			diagram_pap2.Length = 100
			diagram_pap2.pap

			diagram_lcp.sx[1] = diagram_ppp.sx[3]
			diagram_lcp.sy[1] = diagram_ppp.sy[3]
			diagram_lcp.ex[1] = diagram_pap2.ex[1]
			diagram_lcp.ey[1] = diagram_pap2.ey[1]
			diagram_lcp.cx[1] = @cx[1]
			diagram_lcp.cy[1] = @cy[1]
			diagram_lcp.r[1] = @r[1]
			diagram_lcp.lcp

			if (diagram_lcp.Type != 1) 
				print "type 4-1 : lcp.type != 1\n"
				@Type = 0
				return 1
			end
			@sx[3] = diagram_lcp.sx[2]
			@sy[3] = diagram_lcp.sy[2]

			# ~Q */
			diagram_lcp.sx[1] = diagram_ppp.sx[3]
			diagram_lcp.sy[1] = diagram_ppp.sy[3]
			diagram_lcp.ex[1] = diagram_pap2.ex[1]
			diagram_lcp.ey[1] = diagram_pap2.ey[1]
			diagram_lcp.cx[1] = @cx[2]
			diagram_lcp.cy[1] = @cy[2]
			diagram_lcp.r[1] = @r[2]
			diagram_lcp.lcp

			if (diagram_lcp.Type != 1) 
				print "type 4-2 : lcp.type != 1\n"
				@Type = 0
				return 1
			end
			@ex[3] = diagram_lcp.sx[2]
			@ey[3] = diagram_lcp.sy[2]


			# _ P px x2 ̐ */
			diagram_pap2.sx[1] = diagram_ppp.sx[3]
			diagram_pap2.sy[1] = diagram_ppp.sy[3]
			diagram_pap2.Angle = x2
			diagram_pap2.Length = 100
			diagram_pap2.pap

			diagram_lcp.sx[1] = diagram_ppp.sx[3]
			diagram_lcp.sy[1] = diagram_ppp.sy[3]
			diagram_lcp.ex[1] = diagram_pap2.ex[1]
			diagram_lcp.ey[1] = diagram_pap2.ey[1]
			diagram_lcp.cx[1] = @cx[1]
			diagram_lcp.cy[1] = @cy[1]
			diagram_lcp.r[1] = @r[1]
			diagram_lcp.lcp

			if (diagram_lcp.Type != 1) 
				print "type 4-3 : lcp.type != 1\n"
				@Type = 0
				return 1
			end
			@sx[4] = diagram_lcp.sx[2]
			@sy[4] = diagram_lcp.sy[2]

			# ~Q */
			diagram_lcp.sx[1] = diagram_ppp.sx[3]
			diagram_lcp.sy[1] = diagram_ppp.sy[3]
			diagram_lcp.ex[1] = diagram_pap2.ex[1]
			diagram_lcp.ey[1] = diagram_pap2.ey[1]
			diagram_lcp.cx[1] = @cx[2]
			diagram_lcp.cy[1] = @cy[2]
			diagram_lcp.r[1] = @r[2]
			diagram_lcp.lcp

			if (diagram_lcp.Type != 1) 
				print "type 4-4 : lcp.type != 1\n"
				@Type = 0
				return 1
			end
			@ex[4] = diagram_lcp.sx[2]
			@ey[4] = diagram_lcp.sy[2]



		# Q~ڂĂBڐR{ */
		elsif (dist == r1pr2) 
	#		print "Q~ڂĂBڐR{\n"
			@Type = 3



		# Q~dȂĂBڐQ{ */
		elsif (dist < r1pr2 && dist > r1mr2) 
	#		print "Q~dȂĂBڐQ{\n"
			@Type = 2



		# Q~dȂĐڂĂBڐP{ */
		elsif (dist == r1mr2) 
			# dȂĐڂ */
	#		print "Q~dȂĐڂĂBڐP{\n"
			@Type = 1

			# @r[1]  @r[2] ̑召ׁA傫~PɂB */
			if (@r[1] < @r[2]) 
				f_dumy = @cx[1]
				@cx[1] = @cx[2]
				@cx[2] = f_dumy
				f_dumy = @cy[1]
				@cy[1] = @cy[2]
				@cy[2] = f_dumy
				f_dumy = @r[1]
				@r[1] = @r[2]
				@r[2] = f_dumy
				ccltype = 2
			end

			# ~P̒S~Q̒Sւ̊px`߂B */
			diagram_la.sx[1] = @cx[1]
			diagram_la.sy[1] = @cy[1]
			diagram_la.ex[1] = @cx[2]
			diagram_la.ey[1] = @cy[2]
			diagram_la.la

			# ~P̒Spx`ɂqPs_o߂B */
			diagram_pap.sx[1] = @cx[1]
			diagram_pap.sy[1] = @cy[1]
			diagram_pap.Angle = diagram_la.Angle
			diagram_pap.l = @r[1]
			diagram_pap.pap

			# _oʂA~P̒S~Q̒Sւ̒ɐȐ߂B */
			diagram_plp.sx[2] = diagram_pap.ex[1]
			diagram_plp.sy[2] = diagram_pap.ey[1]
			diagram_plp.sx[1] = @cx[1]
			diagram_plp.sy[1] = @cy[1]
			diagram_plp.ex[1] = @cx[2]
			diagram_plp.ey[1] = @cy[2]
			diagram_plp.plp
		
			@sx[1] = diagram_plp.sx[2]
			@sy[1] = diagram_plp.sy[2]
			@ex[1] = diagram_plp.ex[3]
			@ey[1] = diagram_plp.ey[3]
		
			if (ccltype == 2) 
				f_dumy = @cx[1]
				@cx[1] = @cx[2]
				@cx[2] = f_dumy
				f_dumy = @cy[1]
				@cy[1] = @cy[2]
				@cy[2] = f_dumy
				f_dumy = @r[1]
				@r[1] = @r[2]
				@r[2] = f_dumy
				ccltype = 0
			end



		# Q~dȂėĂBڐ 0 { */
		elsif (dist < r1mr2 && sg(@l, COMPA_DIGITS) > 0) 
	#		print "Q~dȂėĂBڐ 0 {\n"
			@Type = 0
			return 1
		end



		# Oڂ钼 */
		if (@Type >= 2) 
			# qP̏nPɂB */
			if (@r[1] > @r[2]) 
				f_dumy = @cx[1]
				@cx[1] = @cx[2]
				@cx[2] = f_dumy
				f_dumy = @cy[1]
				@cy[1] = @cy[2]
				@cy[2] = f_dumy
				f_dumy = @r[1]
				@r[1] = @r[2]
				@r[2] = f_dumy
				ccltype = 1
			end

			# nPnQ̃xNg̊px߂B(RAD) */
			diagram_la.sx[1] = @cx[1]
			diagram_la.sy[1] = @cy[1]
			diagram_la.ex[1] = @cx[2]
			diagram_la.ey[1] = @cy[2]
			diagram_la.la
			diagram_la.Angle = degrad(diagram_la.Angle)
			kaku_o = diagram_la.Angle

			# nPnQ̋߂B */
			diagram_pp.sx[1] = @cx[1]
			diagram_pp.sy[1] = @cy[1]
			diagram_pp.ex[1] = @cx[2]
			diagram_pp.ey[1] = @cy[2]
			diagram_pp.pp

			# p`߂B */
			kaku_a = (@r[2] - @r[1]) / diagram_pp.Length
			kaku_a = atan(kaku_a / (sqrt(-kaku_a * kaku_a + 1)))

			# nPnQ̊px}ip`{XOjpa߂B */

			kaku_a = kaku_a + (PI / 2)
			kaku_b1 = kaku_o + kaku_a
			kaku_b2 = kaku_o - kaku_a

			kaku_b1 = raddeg(kaku_b1)
			kaku_b2 = raddeg(kaku_b2)

			# e~̒Spa̕Ɋeqs_߂B(4R) */
			diagram_pap.sx[1] = @cx[1]
			diagram_pap.sy[1] = @cy[1]
			diagram_pap.Angle = kaku_b1
			diagram_pap.Length = @r[1]
			diagram_pap.pap
			@sx[1] = diagram_pap.ex[1]
			@sy[1] = diagram_pap.ey[1]

			diagram_pap.sx[1] = @cx[1]
			diagram_pap.sy[1] = @cy[1]
			diagram_pap.Angle = kaku_b2
			diagram_pap.Length = @r[1]
			diagram_pap.pap
			@sx[2] = diagram_pap.ex[1]
			@sy[2] = diagram_pap.ey[1]

			diagram_pap.sx[1] = @cx[2]
			diagram_pap.sy[1] = @cy[2]
			diagram_pap.Angle = kaku_b1
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@ex[1] = diagram_pap.ex[1]
			@ey[1] = diagram_pap.ey[1]
			diagram_pap.sx[1] = @cx[2]
			diagram_pap.sy[1] = @cy[2]
			diagram_pap.Angle = kaku_b2
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@ex[2] = diagram_pap.ex[1]
			@ey[2] = diagram_pap.ey[1]

			if (ccltype == 1) 
				f_dumy = @cx[1]
				@cx[1] = @cx[2]
				@cx[2] = f_dumy
				f_dumy = @cy[1]
				@cy[1] = @cy[2]
				@cy[2] = f_dumy
				f_dumy = @r[1]
				@r[1] = @r[2]
				@r[2] = f_dumy
				ccltype = 0
			end
		end



		if (@Type == 3) 
			# Őڂ */
			# ~ 1 ̒S~ 2 ̒S܂ł̐  */
			# @r[1] : @r[2] ɓ_o߂B */
			diagram_ppp.sx[1] = @cx[1]
			diagram_ppp.sy[1] = @cy[1]
			diagram_ppp.ex[1] = @cx[2]
			diagram_ppp.ey[1] = @cy[2]
			diagram_ppp.sx[2] = @r[1]
			diagram_ppp.ex[2] = @r[2]
			diagram_ppp.ppp

			# P_oʂāA~ 1 ̒S~ 2 ̒S܂ł̐ɐȐ߂B */
			diagram_plp.sx[2] = diagram_ppp.sx[3]
			diagram_plp.sy[2] = diagram_ppp.sy[3]
			diagram_plp.sx[1] = @cx[1]
			diagram_plp.sy[1] = @cy[1]
			diagram_plp.ex[1] = @cx[2]
			diagram_plp.ey[1] = @cy[2]
			diagram_plp.plp

			@sx[3] = diagram_ppp.sx[3]
			@sy[3] = diagram_ppp.sy[3]
			@ex[3] = diagram_plp.ex[3]
			@ey[3] = diagram_plp.ey[3]
		end
		return 0
	end



# -------------------------------------------------------------------
# P_ʂ~ɐڂ~
# pcc
#  : 
#      : ߂~̔a    @r[2]
#      : ~̒S         (@cx[1] , @cy[1]) ,@r[1]
#      : _               (@sx[1] , @sy[1])
# ߒl : 
#      : @Type             0 , 1 , 2 , 3 , 4
#      : ~ 1             (@cx[2] , @cy[2]) , @r[2]
#      : ~ 2             (@cx[3] , @cy[3]) , @r[3]
#      : ~ 3             (@cx[4] , @cy[4]) , @r[4]
#      : ~ 4             (@cx[5] , @cy[5]) , @r[5]
def pcc()

	diagram_pp = Diagram.new
	diagram_ccp = Diagram.new
	diagram_la = Diagram.new
	diagram_pap = Diagram.new


	@Type = 0
	# 1_Ɖ~̒SƂ̋ */
	diagram_pp.sx[1] = @sx[1]
	diagram_pp.sy[1] = @sy[1]
	diagram_pp.ex[1] = @cx[1]
	diagram_pp.ey[1] = @cy[1]
	diagram_pp.pp
	
	
	
	# _~̊OɂƂ ------------------------------------------ */
	if (sg(diagram_pp.Length, COMPA_DIGITS) > sg(@r[1], COMPA_DIGITS))
		# 1.2 */
		if (sg(diagram_pp.Length - @r[1], COMPA_DIGITS) <= sg((2 * @r[2]), COMPA_DIGITS))
			# _甼aqQ̉~Ɖ~̒S甼aqP{qQ̉~̌_߂~̒SB */
			diagram_ccp.cx[1] = @sx[1]
			diagram_ccp.cy[1] = @sy[1]
			diagram_ccp.r[1] = @r[2]
			diagram_ccp.cx[2] = @cx[1]
			diagram_ccp.cy[2] = @cy[1]
			diagram_ccp.r[2] = @r[1] + @r[2]
			diagram_ccp.ccp
			@Type = diagram_ccp.Type
			if (diagram_ccp.Type == 1)
				@cx[2] = diagram_ccp.sx[1]
				@cy[2] = diagram_ccp.sy[1]
				@r[2] = @r[2]
			end
			if (diagram_ccp.Type == 2)
				@cx[2] = diagram_ccp.sx[1]
				@cy[2] = diagram_ccp.sy[1]
				@r[2] = @r[2]
				@cx[3] = diagram_ccp.sx[2]
				@cy[3] = diagram_ccp.sy[2]
				@r[3] = @r[2]
			end
		end

		if (sg((diagram_pp.Length + @r[1]), COMPA_DIGITS) <= sg((2 * @r[2]), COMPA_DIGITS))
			# _甼aqQ̉~Ɖ~̒S甼aqQ|qP̉~̌_߂~̒SB */
			diagram_ccp.cx[1] = @sx[1]
			diagram_ccp.cy[1] = @sy[1]	
			diagram_ccp.r[1] = @r[2]
			diagram_ccp.cx[2] = @cx[1]	
			diagram_ccp.cy[2] = @cy[1]	
			diagram_ccp.r[2] = @r[2] - @r[1]
			diagram_ccp.ccp
			if (@Type == 0)
				@cx[2] = diagram_ccp.sx[1]	
				@cy[2] = diagram_ccp.sy[1]	
				@r[2] = @r[2]
				if (diagram_ccp.Type == 2)
					@cx[3] = diagram_ccp.sx[2]	
					@cy[3] = diagram_ccp.sy[2]	
					@r[3] = @r[2]
				end
			elsif (@Type == 1)
				@cx[3] = diagram_ccp.sx[1]	
				@cy[3] = diagram_ccp.sy[1]	
				@r[3] = @r[2]
				if (diagram_ccp.Type == 2)
					@cx[4] = diagram_ccp.sx[2]	
					@cy[4] = diagram_ccp.sy[2]	
					@r[4] = @r[2]
				end
			elsif (@Type == 2)
				@cx[4] = diagram_ccp.sx[1]	
				@cy[4] = diagram_ccp.sy[1]	
				@r[4] = @r[2]
				if (diagram_ccp.Type == 2)
					@cx[5] = diagram_ccp.sx[2]	
					@cy[5] = diagram_ccp.sy[2]	
					@r[5] = @r[2]
				end
			end
			@Type = @Type + diagram_ccp.Type

		else
			@Type = @Type + 0
		end
	end





	# _~̒ɂƂ ------------------------------------------ */
	if (sg(diagram_pp.Length, COMPA_DIGITS) < sg(@r[1], COMPA_DIGITS))
		if ((sg((@r[1] + diagram_pp.Length), COMPA_DIGITS) >= sg((2 * @r[2]), COMPA_DIGITS)) && (sg((@r[1] - diagram_pp.Length), COMPA_DIGITS) <= sg((2 * @r[2]), COMPA_DIGITS)))
			# S甼a(R1-R2)̉~Ɠ_甼a(R2)̉~̌_  */
			diagram_ccp.cx[1] = @cx[1]	
			diagram_ccp.cy[1] = @cy[1]	
			diagram_ccp.r[1] = (@r[1] - @r[2])
			diagram_ccp.cx[2] = @sx[1]	
			diagram_ccp.cy[2] = @sy[1]	
			diagram_ccp.r[2] = @r[2]
			diagram_ccp.ccp
			
			if (diagram_ccp.Type != 0)
				@Type = diagram_ccp.Type
				@cx[2] = diagram_ccp.sx[1]	
				@cy[2] = diagram_ccp.sy[1]
				if (@Type == 2)
					@cx[3] = diagram_ccp.sx[2]	
					@cy[3] = diagram_ccp.sy[2]	
					@r[3] = @r[2]
				end
			else
				@Type = 0
			end
		end
	end





	# _~̏ɂƂ ------------------------------------------ */
	if (sg(diagram_pp.Length, COMPA_DIGITS) == sg(@r[1], COMPA_DIGITS))
		@Type = 2
		# S_܂ł̐̊px`߂B */
		diagram_la.sx[1] = @cx[1]
		diagram_la.sy[1] = @cy[1]
		diagram_la.ex[1] = @sx[1]
		diagram_la.ey[1] = @sy[1]
		diagram_la.la

		# _px`Ŕa`.r[2]̓_  */
		diagram_pap.sx[1] = @sx[1]	
		diagram_pap.sy[1] = @sy[1]
		diagram_pap.Angle = diagram_la.Angle 
		diagram_pap.Length = @r[2]
		diagram_pap.pap
		
		@cx[2] = diagram_pap.ex[1]	
		@cy[2] = diagram_pap.ey[1]

		# _px`{PWOŔa`.r[2]̓_ */
		diagram_pap.sx[1] = @sx[1]	
		diagram_pap.sy[1] = @sy[1]
		diagram_pap.Angle = (diagram_la.Angle + 180) 
		diagram_pap.Length = @r[2]
		diagram_pap.pap
				
		@cx[3] = diagram_pap.ex[1]	
		@cy[3] = diagram_pap.ey[1]	
		@r[3] = @r[2]
	end


	return 0
end



# -------------------------------------------------------------------
# Ɖ~ɐڂ~
# lcc
#  : 
#      : a        @r[2]
#      :          (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
#      : ~         (@cx[1] , @cy[1]) , @r[1]
# ߒl : 
#      : @Type
#      : ~ 1       (@cx[2] , @cy[2]) , @r[2]
#      : ~ 2       (@cx[3] , @cy[3]) , @r[3]
#      : ~ 3       (@cx[4] , @cy[4]) , @r[4]
#      : ~ 4       (@cx[5] , @cy[5]) , @r[5]
#      : ~ 5       (@cx[6] , @cy[6]) , @r[6]
#      : ~ 6       (@cx[7] , @cy[7]) , @r[7]
#      : ~ 7       (@cx[8] , @cy[8]) , @r[8]
#      : ~ 8       (@cx[9] , @cy[9]) , @r[9]
def lcc()

	diagram_plp = Diagram.new
	diagram_pp = Diagram.new
	diagram_la = Diagram.new
	diagram_pap = Diagram.new
	diagram_lcp = Diagram.new
	diagram_lo = Diagram.new


	@Type = 0
	# 1 ==============================================================  */
	# ========== ܂~̒SƐ̋߂B			 ==========  */
	# === start ======================================================  */


	# ------------------------------------------------  */
	# PLP	_ƒ̍ŋߓ_iP_ʂ鐂j			 */
	# ------------------------------------------------  */
	diagram_plp.sx[1] = @sx[1]
	diagram_plp.sy[1] = @sy[1]
	diagram_plp.ex[1] = @ex[1]
	diagram_plp.ey[1] = @ey[1]
	diagram_plp.sx[2] = @cx[1]
	diagram_plp.sy[2] = @cy[1]
	diagram_plp.plp
	
	# ŋߓ_(diagram_plp.ex[2],diagram_plp.ey[2])  */
	# ------------------------------------------------  */
	# PP	Q_Ԃ̋								 */
	# ------------------------------------------------  */
	diagram_pp.sx[1] = @cx[1]	
	diagram_pp.sy[1] = @cy[1]	
	diagram_pp.ex[1] = diagram_plp.ex[2] 
	diagram_pp.ey[1] = diagram_plp.ey[2]
	diagram_pp.pp
	# === end ========================================================  */
	# ========== ܂~̒SƐ̋߂B			 ==========  */
	# ================================================================  */


	dist = sg(diagram_pp.Length, COMPA_DIGITS)
	r1 = sg(@r[1], COMPA_DIGITS)
	lmr1 = sg(diagram_pp.Length - @r[1], COMPA_DIGITS)
	r2x2 = sg(2 * @r[2], COMPA_DIGITS)
	lpr1 = sg(diagram_pp.Length + @r[1], COMPA_DIGITS)
	r2 = sg(@r[2], CALCU_DIGITS)
	r1ml = sg(@r[1] - diagram_pp.Length, COMPA_DIGITS)



	# 2 = start ======================================================  */
	# ========== <   Ɖ~AĂB >				 ==========  */
	# ================================================================  */
	if (dist > r1)
		# -< 1 & 2 >-	*/
		# SA̍ŋߓ_܂ł́Åpx`߂B */
		# ------------------------------------------------  */
		# LA	̊px */
		# ------------------------------------------------  */
		diagram_la.sx[1] = @cx[1]	
		diagram_la.sy[1] = @cy[1]	
		diagram_la.ex[1] = diagram_plp.ex[2] 
		diagram_la.ey[1] = diagram_plp.ey[2]
		diagram_la.la
		
		if (lmr1 <= r2x2)
			# ~̒S dumy.r[2] ItZbg`߂B */
			# ŋߓ_~̒S̊px߂B						*/
			# lah.ANGLE+180  */
			# ------------------------------------------------  */
			# PAP	n_ƊpxƋŒ̏I_߂		 */
			# ------------------------------------------------  */
			# n_vZ  */
			diagram_pap.sx[1] = @sx[1]	
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_la.Angle + 180	
			diagram_pap.Length = @r[2]
			diagram_pap.pap
		
			@sx[2] = diagram_pap.ex[1]	
			@sy[2] = diagram_pap.ey[1]
		
			# I_vZ  */
			diagram_pap.sx[1] = @ex[1]	
			diagram_pap.sy[1] = @ey[1]
			diagram_pap.Angle = diagram_la.Angle + 180	
			diagram_pap.Length = @r[2]
			diagram_pap.pap
		
			@ex[2] = diagram_pap.ex[1]	
			@ey[2] = diagram_pap.ey[1]
		
			# ~̒S甼a (dumy.r[1] + dumy.r[2]) ̉~Ɛ`̌_߂B */
			# ------------------------------------------------  */
			# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
			# ------------------------------------------------  */
			diagram_lcp.sx[1] = @sx[2]	
			diagram_lcp.sy[1] = @sy[2]	
			diagram_lcp.ex[1] = @ex[2]	
			diagram_lcp.ey[1] = @ey[2]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[1] + @r[2])
			diagram_lcp.lcp
			
			@Type = diagram_lcp.Type
			
			@cx[2] = diagram_lcp.sx[2]	
			@cy[2] = diagram_lcp.sy[2]	
			@r[2] = @r[2]
			
			if (diagram_lcp.Type == 2)
				@cx[3] = diagram_lcp.sx[3]	
				@cy[3] = diagram_lcp.sy[3]	
				@r[3] = @r[2]
			end
		end



		# -< 1 & 2 >- OR -< 3 & 4 >-  */
		if (lmr1 <= r2x2)
			# ~̒S dumy.r[2] ItZbg`߂B  */
			# ŋߓ_~̒S̊px߂B */
			# lah.ANGLE+180  */
			# ------------------------------------------------  */
			# PAP	n_ƊpxƋŒ̏I_߂ */
			# ------------------------------------------------  */
			# n_vZ  */
			diagram_pap.sx[1] = @sx[1]
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_la.Angle + 180
			diagram_pap.Length = @r[2]
			diagram_pap.pap
		
			@sx[2] = diagram_pap.ex[1]
			@sy[2] = diagram_pap.ey[1]
		
			# I_vZ  */
			diagram_pap.sx[1] = @ex[1]
			diagram_pap.sy[1] = @ey[1]
			diagram_pap.Angle = diagram_la.Angle + 180
			diagram_pap.Length = @r[2]
			diagram_pap.pap
		
			@ex[2] = diagram_pap.ex[1]
			@ey[2] = diagram_pap.ey[1]
		
			# ~̒S甼a (dumy.r[2] - dumy.r[1]) ̉~Ɛ`̌_߂B */
			# ------------------------------------------------  */
			# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
			# ------------------------------------------------  */
			diagram_lcp.sx[1] = @sx[2]	
			diagram_lcp.sy[1] = @sy[2]	
			diagram_lcp.ex[1] = @ex[2]	
			diagram_lcp.ey[1] = @ey[2]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[2] - @r[1])
			diagram_lcp.lcp
			
			if (@Type == 0)
				if (diagram_lcp.Type == 1)
					@cx[2] = diagram_lcp.sx[2]	
					@cy[2] = diagram_lcp.sy[2]	
					@r[2] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[2] = diagram_lcp.sx[2]	
					@cy[2] = diagram_lcp.sy[2]	
					@r[2] = @r[2]
					@cx[3] = diagram_lcp.sx[3]	
					@cy[3] = diagram_lcp.sy[3]	
					@r[3] = @r[2]
				end
			end
			
			if (@Type == 1)
				if (diagram_lcp.Type == 1)
					@cx[3] = diagram_lcp.sx[2]	
					@cy[3] = diagram_lcp.sy[2]	
					@r[3] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[3] = diagram_lcp.sx[2]	
					@cy[3] = diagram_lcp.sy[2]	
					@r[3] = @r[2]
					@cx[4] = diagram_lcp.sx[3]	
					@cy[4] = diagram_lcp.sy[3]	
					@r[4] = @r[2]
				end
			end
			
			if (@Type == 2)
				if (diagram_lcp.Type == 1)
					@cx[4] = diagram_lcp.sx[2]	
					@cy[4] = diagram_lcp.sy[2]	
					@r[4] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[4] = diagram_lcp.sx[2]	
					@cy[4] = diagram_lcp.sy[2]	
					@r[4] = @r[2]
					@cx[5] = diagram_lcp.sx[3]	
					@cy[5] = diagram_lcp.sy[3]	
					@r[5] = @r[2]
				end
			end
			@Type = @Type + diagram_lcp.Type
		end
	end
	# 2 = end ========================================================  */
	# ========== <   Ɖ~AĂB >				 ==========  */
	# ================================================================  */
	
	
	
	
	
	# 3 = start ======================================================  */
	# ========== < Ɖ~AڂĂB >				 ==========  */
	# ================================================================  */
	if (dist == r1)
		# -< 1 & 2 >-	*/
		# -----	<	ŋߓ_(diagram_plp.ex[2],diagram_plp.ey[2])Őڂ~AQB  >------  */
		@Type = 4
		# SA̍ŋߓ_܂ł́Åpx`߂B */
		# ------------------------------------------------  */
		# LA	̊px									 */
		# ------------------------------------------------  */
		diagram_la.sx[1] = @cx[1]	
		diagram_la.sy[1] = @cy[1]	
		diagram_la.ex[1] = diagram_plp.ex[2] 
		diagram_la.ey[1] = diagram_plp.ey[2]
		diagram_la.la
		
		# ŋߓ_px`Œadumy.r[2]̓_	*/
		# ------------------------------------------------  */
		# PAP	n_ƊpxƋŒ̏I_߂		 */
		# ------------------------------------------------  */
		diagram_pap.sx[1] = diagram_plp.ex[2]	
		diagram_pap.sy[1] = diagram_plp.ey[2]
		diagram_pap.Angle = diagram_la.Angle 
		diagram_pap.Length = @r[2]
		diagram_pap.pap
		
		@cx[2] = diagram_pap.ex[1]	
		@cy[2] = diagram_pap.ey[1]	
		@r[2] = @r[2]
		
		# ŋߓ_px`{PWOŒadumy.r[2]̓_	*/
		# diagram_pap.sx[1] = diagram_plp.ex[2] diagram_pap.sy[1] = diagram_plp.ey[2]  */
		diagram_pap.Angle = (diagram_la.Angle + 180)
		diagram_pap.Length = @r[2]
		diagram_pap.pap
		
		@cx[3] = diagram_pap.ex[1]
		@cy[3] = diagram_pap.ey[1]
		@r[3] = @r[2]
		
		
		
		# -< 3 & 4 >-	*/
		# ~̒S dumy.r[2] ItZbg`߂B */
		# ŋߓ_~̒S̊px߂B */
		# diagram_la.ANGLE+180  */
		# ------------------------------------------------  */
		# PAP	n_ƊpxƋŒ̏I_߂		 */
		# ------------------------------------------------  */
		# n_vZ  */
		diagram_pap.sx[1] = @sx[1]	
		diagram_pap.sy[1] = @sy[1]
		diagram_pap.Angle = diagram_la.Angle + 180	
		diagram_pap.Length = @r[2]
		diagram_pap.pap
		
		@sx[2] = diagram_pap.ex[1]	
		@sy[2] = diagram_pap.ey[1]
		
		# I_vZ  */
		diagram_pap.sx[1] = @ex[1]	
		diagram_pap.sy[1] = @ey[1]
		diagram_pap.Angle = diagram_la.Angle + 180	
		diagram_pap.Length = @r[2]
		diagram_pap.pap
		
		@ex[2] = diagram_pap.ex[1]	
		@ey[2] = diagram_pap.ey[1]
		
		# ~̒S甼a (dumy.r[1] + dumy.r[2]) ̉~Ɛ`̌_߂B */
		# ------------------------------------------------  */
		# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
		# ------------------------------------------------  */
		diagram_lcp.sx[1] = @sx[2] 
		diagram_lcp.sy[1] = @sy[2]	
		diagram_lcp.ex[1] = @ex[2]	
		diagram_lcp.ey[1] = @ey[2]
		diagram_lcp.cx[1] = @cx[1]	
		diagram_lcp.cy[1] = @cy[1]	
		diagram_lcp.r[1] = (@r[1] + @r[2])
		diagram_lcp.lcp
		
		@cx[4] = diagram_lcp.sx[2]	
		@cy[4] = diagram_lcp.sy[2]	
		@r[4] = @r[2]
		@cx[5] = diagram_lcp.sx[3]	
		@cy[5] = diagram_lcp.sy[3]	
		@r[5] = @r[2]
	end
	# 3 = end ========================================================  */
	# ========== < Ɖ~AڂĂB >				 ==========  */
	# ================================================================  */
	
	
	
	
	
	# 4 = start ======================================================  */
	# ========== < Ɖ~AdȂĂB >				 ==========  */
	# ================================================================  */
	if (dist < r1)
		# -< 1 & 2 & 3 & 4 >-	*/
		# 𗼕 dumy.r[2] ItZbg`Aa߂B */
		# ------------------------------------------------  */
		# LO	n_ƏI_^̃ItZbg			 */
		# ------------------------------------------------  */
		diagram_lo.sx[1] = @sx[1]	
		diagram_lo.sy[1] = @sy[1]	
		diagram_lo.ex[1] = @ex[1]	
		diagram_lo.ey[1] = @ey[1]	
		diagram_lo.Length = @r[2]
		diagram_lo.lo
		
		# `ƒS甼a (dumy.r[1] + dumy.r[2]) ̉~̌_߂B */
		# ------------------------------------------------  */
		# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
		# ------------------------------------------------  */
		diagram_lcp.sx[1] = diagram_lo.sx[2] 
		diagram_lcp.sy[1] = diagram_lo.sy[2] 
		diagram_lcp.ex[1] = diagram_lo.ex[2] 
		diagram_lcp.ey[1] = diagram_lo.ey[2]
		diagram_lcp.cx[1] = @cx[1]	
		diagram_lcp.cy[1] = @cy[1]	
		diagram_lcp.r[1] = (@r[1] + @r[2])
		diagram_lcp.lcp
		
		@cx[2] = diagram_lcp.sx[2]	
		@cy[2] = diagram_lcp.sy[2]	
		@r[2] = @r[2]
		@cx[3] = diagram_lcp.sx[3]	
		@cy[3] = diagram_lcp.sy[3]	
		@r[3] = @r[2]
		
		# aƒS甼a (dumy.r[1] + dumy.r[2]) ̉~̌_߂B */
		diagram_lcp.sx[1] = diagram_lo.sx[3] 
		diagram_lcp.sy[1] = diagram_lo.sy[3] 
		diagram_lcp.ex[1] = diagram_lo.ex[3] 
		diagram_lcp.ey[1] = diagram_lo.ey[3]
		diagram_lcp.cx[1] = @cx[1]	
		diagram_lcp.cy[1] = @cy[1]	
		diagram_lcp.r[1] = (@r[1] + @r[2])
		diagram_lcp.lcp
		
		@cx[4] = diagram_lcp.sx[2]	
		@cy[4] = diagram_lcp.sy[2]	
		@r[4] = @r[2]
		@cx[5] = diagram_lcp.sx[3]	
		@cy[5] = diagram_lcp.sy[3]	
		@r[5] = @r[2]
		
		@Type = 4
		
		
		
		
		# L ---  */
		if ((lpr1 > r2) && dist != 0)
			# 𒆐S̕dumy.r[2]ItZbg`߂B */
			# ̍ŋߓ_AS܂ł́Åpx`߂B */
			# ------------------------------------------------  */
			# LA	̊px									 */
			# ------------------------------------------------  */
			diagram_la.sx[1] = diagram_plp.ex[2] 
			diagram_la.sy[1] = diagram_plp.ey[2] 
			diagram_la.ex[1] = @cx[1]	
			diagram_la.ey[1] = @cy[1]
			diagram_la.la
		
			# ŋߓ_px`Œadumy.r[2]̓_	*/
			# ------------------------------------------------  */
			# PAP	n_ƊpxƋŒ̏I_߂		 */
			# ------------------------------------------------  */
			diagram_pap.sx[1] = @sx[1]	
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = diagram_la.Angle 
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@sx[2] = diagram_pap.ex[1]	
			@sy[2] = diagram_pap.ey[1]
		
			diagram_pap.sx[1] = @ex[1]	
			diagram_pap.sy[1] = @ey[1]
			diagram_pap.Angle = diagram_la.Angle 
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@ex[2] = diagram_pap.ex[1]	
			@ey[2] = diagram_pap.ey[1]
		
			# S甼a(dumy.r[1] - dumy.r[2])̉~Ɛ`̌_߂B */
		
			# ------------------------------------------------  */
			# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
			# ------------------------------------------------  */
			diagram_lcp.sx[1] = @sx[2]	
			diagram_lcp.sy[1] = @sy[2]	
			diagram_lcp.ex[1] = @ex[2]	
			diagram_lcp.ey[1] = @ey[2]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[1] - @r[2])
			diagram_lcp.lcp
		
			if (diagram_lcp.Type == 1)
				@cx[6] = diagram_lcp.sx[2]	
				@cy[6] = diagram_lcp.sy[2]	
				@r[6] = @r[2]
			end
			if (diagram_lcp.Type == 2)
				@cx[6] = diagram_lcp.sx[2]	
				@cy[6] = diagram_lcp.sy[2]	
				@r[6] = @r[2]
				@cx[7] = diagram_lcp.sx[3]	
				@cy[7] = diagram_lcp.sy[3]	
				@r[7] = @r[2]
			end
			@Type = @Type + diagram_lcp.Type
		end
		
		
		
		
		#  ---  */
		if ((r1ml > r2) && dist != 0)
			# 𒆐SƋt̕dumy.r[2]ItZbga߂B */
			# ̍ŋߓ_AS܂ł́Åpx`߂B */
			# ------------------------------------------------  */
			# LA	̊px									 */
			# ------------------------------------------------  */
			diagram_la.sx[1] = diagram_plp.ex[2] 
			diagram_la.sy[1] = diagram_plp.ey[2] 
			diagram_la.ex[1] = @cx[1]	
			diagram_la.ey[1] = @cy[1]
			diagram_la.la
		
			# ŋߓ_px`Œadumy.r[2]̓_	*/
			# ------------------------------------------------  */
			# PAP	n_ƊpxƋŒ̏I_߂		 */
			# ------------------------------------------------  */
			diagram_pap.sx[1] = @sx[1]	
			diagram_pap.sy[1] = @sy[1]
			diagram_pap.Angle = (diagram_la.Angle + 180) 
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@sx[2] = diagram_pap.ex[1]	
			@sy[2] = diagram_pap.ey[1]
		
			diagram_pap.sx[1] = @ex[1]	
			diagram_pap.sy[1] = @ey[1]
			diagram_pap.Angle = (diagram_la.Angle + 180) 
			diagram_pap.Length = @r[2]
			diagram_pap.pap
			@ex[2] = diagram_pap.ex[1]	
			@ey[2] = diagram_pap.ey[1]
		
			# S甼a(@r[1]-dumy.r[2])̉~Ɛǎ_߂B */
		
			# ------------------------------------------------  */
			# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
			# ------------------------------------------------  */
			diagram_lcp.sx[1] = @sx[2]	
			diagram_lcp.sy[1] = @sy[2]	
			diagram_lcp.ex[1] = @ex[2]	
			diagram_lcp.ey[1] = @ey[2]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[1] - @r[2])
			diagram_lcp.lcp
			
			
			
			if (@Type == 4)
				if (diagram_lcp.Type == 1)
					@cx[6] = diagram_lcp.sx[2]	
					@cy[6] = diagram_lcp.sy[2]	
					@r[6] = @r[2]
				end
			
				if (diagram_lcp.Type == 2)
					@cx[6] = diagram_lcp.sx[2]	
					@cy[6] = diagram_lcp.sy[2]	
					@r[6] = @r[2]
					@cx[7] = diagram_lcp.sx[3]	
					@cy[7] = diagram_lcp.sy[3]	
					@r[7] = @r[2]
				end
			end
			
			if (@Type == 5)
				if (diagram_lcp.Type == 1)
					@cx[7] = diagram_lcp.sx[2]	
					@cy[7] = diagram_lcp.sy[2] 
					@r[7] = @r[2]
				end
			
				if (diagram_lcp.Type == 2)
					@cx[7] = diagram_lcp.sx[2]	
					@cy[7] = diagram_lcp.sy[2]	
					@r[7] = @r[2]
					@cx[8] = diagram_lcp.sx[3]	
					@cy[8] = diagram_lcp.sy[3]	
					@r[8] = @r[2]
				end
			end
			
			if (@Type == 6)
				if (diagram_lcp.Type == 1)
					@cx[8] = diagram_lcp.sx[2]	
					@cy[8] = diagram_lcp.sy[2]	
					@r[8] = @r[2]
				end
			
				if (diagram_lcp.Type == 2)
					@cx[8] = diagram_lcp.sx[2]	
					@cy[8] = diagram_lcp.sy[2]	
					@r[8] = @r[2]
					@cx[9] = diagram_lcp.sx[3]	
					@cy[9] = diagram_lcp.sy[3]	
					@r[9] = @r[2]
				end
			end
			@Type = @Type + diagram_lcp.Type
		end
		
		
		
		# ~̒SʂƂB ---  */
		if ((dist == 0) && r1 >= r2x2)
			# 𗼕 @r[2] ItZbg`Aa߂B */
			# ------------------------------------------------  */
			# LO	n_ƏI_^̃ItZbg			 */
			# ------------------------------------------------  */
			diagram_lo.sx[1] = @sx[1]	
			diagram_lo.sy[1] = @sy[1]	
			diagram_lo.ex[1] = @ex[1]	
			diagram_lo.ey[1] = @ey[1]	
			diagram_lo.Length = @r[2]
			diagram_lo.lo
		
			# `ƒS甼a (@r[1]-@r[2]) ̉~̌_߂B */
			# ------------------------------------------------  */
			# LCP Ɖ~̌_	߂ẴOtBbNX P126  */
			# ------------------------------------------------  */
			diagram_lcp.sx[1] = diagram_lo.sx[2] 
			diagram_lcp.sy[1] = diagram_lo.sy[2] 
			diagram_lcp.ex[1] = diagram_lo.ex[2] 
			diagram_lcp.ey[1] = diagram_lo.ey[2]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[1] - @r[2])
			diagram_lcp.lcp
		
			if (diagram_lcp.Type == 1)
				@cx[6] = diagram_lcp.sx[2]	
				@cy[6] = diagram_lcp.sy[2]	
				@r[6] = @r[2]
			end
			
			if (diagram_lcp.Type == 2)
				@cx[6] = diagram_lcp.sx[2]	
				@cy[6] = diagram_lcp.sy[2]	
				@r[6] = @r[2]
				@cx[7] = diagram_lcp.sx[3]	
				@cy[7] = diagram_lcp.sy[3]	
				@r[7] = @r[2]
			end
						
			@Type = @Type + diagram_lcp.Type
			
			# aƒS甼a (@r[1]-@r[2]) ̉~̌_߂B */
			diagram_lcp.sx[1] = diagram_lo.sx[3] 
			diagram_lcp.sy[1] = diagram_lo.sy[3] 
			diagram_lcp.ex[1] = diagram_lo.ex[3] 
			diagram_lcp.ey[1] = diagram_lo.ey[3]
			diagram_lcp.cx[1] = @cx[1]	
			diagram_lcp.cy[1] = @cy[1]	
			diagram_lcp.r[1] = (@r[1] - @r[2])
			diagram_lcp.lcp
		
			if (@Type == 4)
				if (diagram_lcp.Type == 1)
					@cx[6] = diagram_lcp.sx[2]	
					@cy[6] = diagram_lcp.sy[2]	
					@r[6] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[6] = diagram_lcp.sx[2]	
					@cy[6] = diagram_lcp.sy[2]	
					@r[6] = @r[2]
					@cx[7] = diagram_lcp.sx[3]	
					@cy[7] = diagram_lcp.sy[3]	
					@r[7] = @r[2]
				end
			end
				
			if (@Type == 5)
				if (diagram_lcp.Type == 1)
					@cx[7] = diagram_lcp.sx[2]	
					@cy[7] = diagram_lcp.sy[2]	
					@r[7] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[7] = diagram_lcp.sx[2]	
					@cy[7] = diagram_lcp.sy[2]	
					@r[7] = @r[2]
					@cx[8] = diagram_lcp.sx[3]	
					@cy[8] = diagram_lcp.sy[3]	
					@r[8] = @r[2]
				end
			end
				
			if (@Type == 6)
				if (diagram_lcp.Type == 1)
					@cx[8] = diagram_lcp.sx[2]	
					@cy[8] = diagram_lcp.sy[2]	
					@r[8] = @r[2]
				end
				if (diagram_lcp.Type == 2)
					@cx[8] = diagram_lcp.sx[2]
					@cy[8] = diagram_lcp.sy[2]
					@r[8] = @r[2]
					@cx[9] = diagram_lcp.sx[3]
					@cy[9] = diagram_lcp.sy[3]
					@r[9] = @r[2]
				end
			end
			@Type = @Type + diagram_lcp.Type
		end
	end
	# 4 = end ========================================================  */
	# ========== < Ɖ~AdȂĂB >				 ==========  */
	# ================================================================  */

	return 0
end 



# -------------------------------------------------------------------
# Q_ʂ~
# ppc
#  : 
#      : _ 1       (@sx[1] , @sy[1])
#      : _ 2       (@sx[2] , @sy[2])
#      : ~̔a    @r[1]
# ߒl : 
#      : @Type       0 , 1 , 2
#      : ~ 1       (@cx[1] , @cy[1]) , @r[1]
#      : ~ 2       (@cx[2] , @cy[2]) , @r[2]
def ppc()

	diagram_pp = Diagram.new
	diagram_ccp = Diagram.new


	# ---	Q_Ԃ̋~𔻕  ---  */
	diagram_pp.sx[1] = @sx[1]
	diagram_pp.sy[1] = @sy[1]
	diagram_pp.ex[1] = @sx[2]
	diagram_pp.ey[1] = @sy[2]
	diagram_pp.pp

	if ( sg(diagram_pp.Length, COMPA_DIGITS) < sg(2 * @r[1], COMPA_DIGITS) )
		@Type = 2
	elsif ( sg(diagram_pp.Length, COMPA_DIGITS) == sg(2 * @r[1], COMPA_DIGITS) )
		@Type = 1
	elsif ( sg(diagram_pp.Length, COMPA_DIGITS) > sg(2 * @r[1], COMPA_DIGITS) )
		@Type = 0
	end


	if (@Type != 0)
		# _PƓ_Q𒆐SƂ锼aq̂Q~̌_߂~̌_  */
		diagram_ccp.cx[1] = @sx[1]	
		diagram_ccp.cy[1] = @sy[1]	
		diagram_ccp.r[1] = @r[1]
		diagram_ccp.cx[2] = @sx[2]	
		diagram_ccp.cy[2] = @sy[2]	
		diagram_ccp.r[2] = @r[1]
		diagram_ccp.ccp

		@cx[1] = diagram_ccp.sx[1]	
		@cy[1] = diagram_ccp.sy[1]
		@cx[2] = diagram_ccp.sx[2]
		@cy[2] = diagram_ccp.sy[2]
		@r[2] = @r[1]
	end

	return 0
end



# -------------------------------------------------------------------
# P_ʂ蒼ɐڂ~
# plc
#  : 
#      : _           (@sx[1] , @sy[1])
#      :            (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
#      : ~̔a      @r[3]
# ߒl : 
#      : @Type
#      : ~ 1         (@cx[3]  , @cy[3]) , @r[3]
#      : ~ 2         (@cx[4]  , @cy[4]) , @r[4]
def plc()

	diagram_plp = Diagram.new
	diagram_pp = Diagram.new
	diagram_la = Diagram.new
	diagram_pap = Diagram.new
	diagram_lcp = Diagram.new
	diagram_lo = Diagram.new


	# _Ɛ̋߂B */
	# 𔼌aqRItZbg`߂B */
	diagram_plp.sx[1] = @sx[2]	
	diagram_plp.sy[1] = @sy[2]	
	diagram_plp.ex[1] = @ex[2]	
	diagram_plp.ey[1] = @ey[2]
	diagram_plp.sx[2] = @sx[1]	
	diagram_plp.sy[2] = @sy[1]
	diagram_plp.plp
	# _(diagram_plp.ex[2],diagram_plp.ey[2])	*/

	diagram_pp.sx[1] = @sx[1]	
	diagram_pp.sy[1] = @sy[1]	
	diagram_pp.ex[1] = diagram_plp.ex[2] 
	diagram_pp.ey[1] = diagram_plp.ey[2]
	diagram_pp.pp

	dist = sg(diagram_pp.Length, COMPA_DIGITS)



	if (dist > 0)
		diagram_la.sx[1] = diagram_plp.ex[2] 
		diagram_la.sy[1] = diagram_plp.ey[2]
		diagram_la.ex[1] = @sx[1]	
		diagram_la.ey[1] = @sy[1]
		diagram_la.la

		diagram_pap.sx[1] = @sx[2]	
		diagram_pap.sy[1] = @sy[2]	
		diagram_pap.Angle = diagram_la.Angle 
		diagram_pap.Length = @r[3]
		diagram_pap.pap

		diagram_lcp.sx[1] = diagram_pap.ex[1]	
		diagram_lcp.sy[1] = diagram_pap.ey[1]

		diagram_pap.sx[1] = @ex[2]	
		diagram_pap.sy[1] = @ey[2]	
		diagram_pap.Angle = diagram_la.Angle 
		diagram_pap.Length = @r[3]
		diagram_pap.pap

		diagram_lcp.ex[1] = diagram_pap.ex[1]	
		diagram_lcp.ey[1] = diagram_pap.ey[1]

		# _𒆐SƂaqR̉~ƁA`̌_߂B */
		diagram_lcp.cx[1] = @sx[1]	
		diagram_lcp.cy[1] = @sy[1]	
		diagram_lcp.r[1] = @r[3]
		diagram_lcp.lcp

		if (diagram_lcp.Type == 0)
			@Type = 0
		end

		if (diagram_lcp.Type == 1)
			@Type = 1
			@cx[3] = diagram_lcp.sx[2]	
			@cy[3] = diagram_lcp.sy[2]
		end

		if (diagram_lcp.Type == 2)
			@Type = 2
			@cx[3] = diagram_lcp.sx[2]	
			@cy[3] = diagram_lcp.sy[2]
			@cx[4] = diagram_lcp.sx[3]	
			@cy[4] = diagram_lcp.sy[3]	
			@r[4] = @r[3]
		end
	end


	if (dist == 0)
		diagram_lo.sx[1] = @sx[2]
		diagram_lo.sy[1] = @sy[2]
		diagram_lo.ex[1] = @ex[2]
		diagram_lo.ey[1] = @ey[2]
		diagram_lo.Length = @r[3]
		diagram_lo.lo

		diagram_lcp.sx[1] = diagram_lo.sx[2]
		diagram_lcp.sy[1] = diagram_lo.sy[2]
		diagram_lcp.ex[1] = diagram_lo.ex[2]
		diagram_lcp.ey[1] = diagram_lo.ey[2]
		diagram_lcp.cx[1] = @sx[1]
		diagram_lcp.cy[1] = @sy[1]
		diagram_lcp.r[1] = @r[3]
		diagram_lcp.lcp

		@cx[3] = diagram_lcp.sx[2]
		@cy[3] = diagram_lcp.sy[2]
		@r[3] = @r[3]

		diagram_lcp.sx[1] = diagram_lo.sx[3] 
		diagram_lcp.sy[1] = diagram_lo.sy[3] 
		diagram_lcp.ex[1] = diagram_lo.ex[3] 
		diagram_lcp.ey[1] = diagram_lo.ey[3]
		diagram_lcp.cx[1] = @sx[1]	
		diagram_lcp.cy[1] = @sy[1]	
		diagram_lcp.r[1] = @r[3]
		diagram_lcp.lcp

		@cx[4] = diagram_lcp.sx[2]	
		@cy[4] = diagram_lcp.sy[2]	
		@r[4] = @r[3]

		@Type = 2
	end

	return 0
end



# -------------------------------------------------------------------
# Qɐڂ~
# llc
#  : 
#      :  1    (@sx[1] , @sy[1]) -  (@ex[1] , @ey[1])
#      :  2    (@sx[2] , @sy[2]) -  (@ex[2] , @ey[2])
#      : a     @r[1]
# ߒl : 
#      : ~ 1    (@cx[1] , @cy[1]) , @r[1]
#      : ~ 2    (@cx[2] , @cy[2]) , @r[2]
#      : ~ 3    (@cx[3] , @cy[3]) , @r[3]
#      : ~ 4    (@cx[4] , @cy[4]) , @r[4]
def llc()

	diagram_lo = Diagram.new
	diagram_llp = Diagram.new


	# P𔼌aqItZbgĐPPƐPQ߂B */
	diagram_lo.sx[1] = @sx[1]
	diagram_lo.sy[1] = @sy[1]
	diagram_lo.ex[1] = @ex[1]
	diagram_lo.ey[1] = @ey[1]
	diagram_lo.Length = @r[1]
	diagram_lo.lo
	
	sx11 = diagram_lo.sx[2]
	sy11 = diagram_lo.sy[2]
	ex11 = diagram_lo.ex[2]
	ey11 = diagram_lo.ey[2]
	sx12 = diagram_lo.sx[3]
	sy12 = diagram_lo.sy[3]
	ex12 = diagram_lo.ex[3]
	ey12 = diagram_lo.ey[3]
	
	# Q𔼌aqItZbgĐQPƐQQ߂B */
	diagram_lo.sx[1] = @sx[2]
	diagram_lo.sy[1] = @sy[2]
	diagram_lo.ex[1] = @ex[2]
	diagram_lo.ey[1] = @ey[2]
	diagram_lo.Length = @r[1]
	diagram_lo.lo
	
	sx21 = diagram_lo.sx[2]
	sy21 = diagram_lo.sy[2]
	ex21 = diagram_lo.ex[2]
	ey21 = diagram_lo.ey[2]
	sx22 = diagram_lo.sx[3]
	sy22 = diagram_lo.sy[3]
	ex22 = diagram_lo.ex[3]
	ey22 = diagram_lo.ey[3]
	
	# PPƐQPƂ̌_߂~P̒S */
	diagram_llp.sx[1] = sx11
	diagram_llp.sy[1] = sy11
	diagram_llp.ex[1] = ex11
	diagram_llp.ey[1] = ey11
	diagram_llp.sx[2] = sx21
	diagram_llp.sy[2] = sy21
	diagram_llp.ex[2] = ex21
	diagram_llp.ey[2] = ey21
	diagram_llp.llp
	
	if (diagram_llp.Type == 0)
		@Type = 0
		return 1
	end

	@Type = 4

	@cx[1] = diagram_llp.sx[3]
	@cy[1] = diagram_llp.sy[3]

	# PPƐQQƂ̌_߂~Q̒S */
	diagram_llp.sx[1] = sx11
	diagram_llp.sy[1] = sy11
	diagram_llp.ex[1] = ex11
	diagram_llp.ey[1] = ey11
	diagram_llp.sx[2] = sx22
	diagram_llp.sy[2] = sy22
	diagram_llp.ex[2] = ex22
	diagram_llp.ey[2] = ey22
	diagram_llp.llp

	@cx[2] = diagram_llp.sx[3]
	@cy[2] = diagram_llp.sy[3]
	@r[2] = @r[1]

	# PQƐQPƂ̌_߂~R̒S */
	diagram_llp.sx[1] = sx12
	diagram_llp.sy[1] = sy12
	diagram_llp.ex[1] = ex12
	diagram_llp.ey[1] = ey12
	diagram_llp.sx[2] = sx21
	diagram_llp.sy[2] = sy21
	diagram_llp.ex[2] = ex21
	diagram_llp.ey[2] = ey21
	diagram_llp.llp

	@cx[3] = diagram_llp.sx[3]
	@cy[3] = diagram_llp.sy[3]
	@r[3] = @r[1]

	# PQƐQQƂ̌_߂~S̒S */
	diagram_llp.sx[1] = sx12
	diagram_llp.sy[1] = sy12
	diagram_llp.ex[1] = ex12
	diagram_llp.ey[1] = ey12
	diagram_llp.sx[2] = sx22
	diagram_llp.sy[2] = sy22
	diagram_llp.ex[2] = ex22
	diagram_llp.ey[2] = ey22
	diagram_llp.llp

	@cx[4] = diagram_llp.sx[3]
	@cy[4] = diagram_llp.sy[3]
	@r[4] = @r[1]

	return 0
end



# -------------------------------------------------------------------
# Q
# lll
#  : 
#      :  1    (@sx[1] , @sy[1]) -  (@ex[1] , @ey[1])
#      :  2    (@sx[2] , @sy[2]) -  (@ex[2] , @ey[2])
# ߒl : 
#      : @Type    0:Qs
#      :       (@sx[3] , @sy[3]) - (@ex[3] , @ey[3])  xNgōl
def lll()

	diagram_la = Diagram.new
	diagram_llp = Diagram.new
	diagram_pap = Diagram.new

	a0 = 0.0
	a1 = 0.0
	a2 = 0.0


	# P̊px */
	diagram_la.sx[1] = @sx[1]	
	diagram_la.sy[1] = @sy[1]	
	diagram_la.ex[1] = @ex[1]	
	diagram_la.ey[1] = @ey[1]
	diagram_la.la
	a1 = diagram_la.Angle

	# Q̊px */
	diagram_la.sx[1] = @sx[2]	
	diagram_la.sy[1] = @sy[2]	
	diagram_la.ex[1] = @ex[2]	
	diagram_la.ey[1] = @ey[2]
	diagram_la.la
	a2 = diagram_la.Angle

	# PƒQ̍px` */
	if (sg(a1, COMPA_DIGITS) > sg(a2, COMPA_DIGITS))
		a0 = a1 - a2
		a0 = a2 + (a0 / 2)
	end
	if (sg(a1, COMPA_DIGITS) == sg(a2, COMPA_DIGITS))
		@type = 0
		return 1
	end
	if (sg(a1, COMPA_DIGITS) < sg(a2, COMPA_DIGITS))
		a0 = a2 - a1
		a0 = a1 + (a0 / 2)
	end

	# PƒQ̌_n_ */
	diagram_llp.sx[1] = @sx[1]
	diagram_llp.sy[1] = @sy[1]
	diagram_llp.ex[1] = @ex[1]
	diagram_llp.ey[1] = @ey[1]
	diagram_llp.sx[2] = @sx[2]
	diagram_llp.sy[2] = @sy[2]
	diagram_llp.ex[2] = @ex[2]
	diagram_llp.ey[2] = @ey[2]
	diagram_llp.llp

	@sx[3] = diagram_llp.sx[3]
	@sy[3] = diagram_llp.sy[3]

	# n_px`ɋ 100 ̒ */
	diagram_pap.sx[1] = @sx[3]	
	diagram_pap.sy[1] = @sy[3]	
	diagram_pap.Angle = a0	
	diagram_pap.Length = 100
	diagram_pap.pap
	
	@ex[3] = diagram_pap.ex[1]	
	@ey[3] = diagram_pap.ey[1]
	@Type = 1

	return 0
end



# -------------------------------------------------------------------
# _ʂAɕsȒ
# pll
#  : 
#      : _       (@sx[1] , @sy[1])
#      :        (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
# ߒl : 
#      : @Type
#      :        (@sx[3] , @sy[3]) - (@ex[3] , @ey[3])
def pll()

	diagram_plp = Diagram.new


	# PLP	_ƒ̍ŋߓ_iP_ʂ鐂j */
	diagram_plp.sx[2] = @sx[1]
	diagram_plp.sy[2] = @sy[1]
	diagram_plp.sx[1] = @sx[2]
	diagram_plp.sy[1] = @sy[2]
	diagram_plp.ex[1] = @ex[2]
	diagram_plp.ey[1] = @ey[2]
	diagram_plp.plp
	# ŋߓ_ (diagram_plp.ex[2],diagram_plp.ey[2])  */

	dx = @sx[1] - diagram_plp.ex[2]
	dy = @sy[1] - diagram_plp.ey[2]

	@sx[3] = @sx[2] + dx
	@sy[3] = @sy[2] + dy
	@ex[3] = @ex[2] + dx
	@ey[3] = @ey[2] + dy

	@Type = 1
	return 1
end



# -------------------------------------------------------------------
# ~ɐڂpx`̐ڐ
# cal
#  : 
#      : ~      (@cx[1] , @cy[1]) , @r[1]
#      : px     @Angle
#      :      @Length (l = 0 ̂Ƃ l=100)
# ߒl : 
#      : type     0 , 2
#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
#      :  2    (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
def cal()

	diagram_lo = Diagram.new
	diagram_pap = Diagram.new


	if (@Length == 0) 
		@Length = 100.0
	end

	# Spx`̐ */
	diagram_pap.sx[1] = @cx[1]
	diagram_pap.sy[1] = @cy[1]
	diagram_pap.Angle = @Angle
	diagram_pap.Length = @Length
	diagram_pap.pap
	# (diagram_pap.sx[1] , diagram_pap.sy[1]) - (diagram_pap.ex[1] , diagram_pap.ey[1])

	# ̐𔼌aItZbg  */
	diagram_lo.sx[1] = diagram_pap.sx[1]
	diagram_lo.sy[1] = diagram_pap.sy[1]
	diagram_lo.ex[1] = diagram_pap.ex[1]
	diagram_lo.ey[1] = diagram_pap.ey[1]
	diagram_lo.Length = @r[1]
	diagram_lo.lo
	# (diagram_lo.sx[2] , diagram_lo.sy[2]) - (diagram_lo.ex[2] , diagram_lo.ey[2])
	# (diagram_lo.sx[3] , diagram_lo.sy[3]) - (diagram_lo.ex[3] , diagram_lo.ey[3])

	@Type = 2
	@sx[1] = diagram_lo.sx[2]
	@sy[1] = diagram_lo.sy[2]
	@ex[1] = diagram_lo.ex[2]
	@ey[1] = diagram_lo.ey[2]
	@sx[2] = diagram_lo.sx[3]
	@sy[2] = diagram_lo.sy[3]
	@ex[2] = diagram_lo.ex[3]
	@ey[2] = diagram_lo.ey[3]

	return 1
end



# -------------------------------------------------------------------
# Q~ɐڂ~
# ccc
#  : 
#      : ~ 1     (@cx[1] , @cy[1]) ,@r[1]
#      : ~ 2     (@cx[2] , @cy[2]) ,@r[2]
#      : ~̔a  @r[3]
# ߒl : 
#      : @Type
#      : ~ 1     (@cx[ 3]  , @cy[ 3]) , @r[ 3]
#      : ~ 2     (@cx[ 4]  , @cy[ 4]) , @r[ 4]
#      : ~ 3     (@cx[ 5]  , @cy[ 5]) , @r[ 5]
#      : ~ 4     (@cx[ 6]  , @cy[ 6]) , @r[ 6]
#      : ~ 5     (@cx[ 7]  , @cy[ 7]) , @r[ 7]
#      : ~ 6     (@cx[ 8]  , @cy[ 8]) , @r[ 8]
#      : ~ 7     (@cx[ 9]  , @cy[ 9]) , @r[ 9]
#      : ~ 8     (@cx[10]  , @cy[10]) , @r[10]
#      : ~ 9     (@cx[11]  , @cy[11]) , @r[11]
#      : ~ 10    (@cx[12]  , @cy[12]) , @r[12]
def ccc()

	diagram_pp = Diagram.new
	diagram_ccp = Diagram.new
	diagram_la = Diagram.new
	diagram_pap = Diagram.new


	i = 2

	# ~Q̕傫Ȃ悤ɂB */
	if (@r[1] > @r[2])
		dummyD = @cx[1]
		@cx[1] = @cx[2]
		@cx[2] = dummyD

		dummyD = @cy[1]
		@cy[1] = @cy[2]
		@cy[2] = dummyD

		dummyD = @r[1]
		@r[1] = @r[2]
		@r[2] = dummyD
	end

	# 2~̒S̋vZ */
	diagram_pp.sx[1] = @cx[1]
	diagram_pp.sy[1] = @cy[1]
	diagram_pp.ex[1] = @cx[2]
	diagram_pp.ey[1] = @cy[2]
	diagram_pp.pp



	# @ ~PƉ~QĂB ----------------------------------- */
	if (sg(diagram_pp.Length, CALCU_DIGITS) > sg(@r[1] + @r[2], CALCU_DIGITS)) 
		# < 1 & 2 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length - @r[1] - @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[1]+@R[3] ̉~ */
			# ~Q̒S甼a @r[2]+@R[3] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#	 Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#	   @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] + @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] + @r[3]
			diagram_ccp.ccp
			
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end

			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 3 & 4 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length + @r[1] - @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[3]-@R[1] ̉~ */
			# ~Q̒S甼a @r[3]+@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#	 Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#	   @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] - @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] + @r[2]
			diagram_ccp.ccp
			
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 5 & 6 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length + @r[2] - @r[1], CALCU_DIGITS)) 
			# ~P̒S甼a @r[3]+@R[1] ̉~ */
			# ~Q̒S甼a @r[3]-@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#	 Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#	   @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] + @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] - @r[2]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end

			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 7 & 8 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length + @r[1] + @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[3]-@R[1] ̉~ */
			# ~Q̒S甼a @r[3]-@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#	 Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#	   @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] - @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] - @r[2]
			diagram_ccp.ccp

			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end

			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end
	end





	# A ~PƉ~QדmڂĂB ----------------------------- */
	if (sg(diagram_pp.Length, CALCU_DIGITS) == sg(@r[1] + @r[2], CALCU_DIGITS)) 
		# < 1 & 2 > */
		# ~P̒S甼a @r[3]+@R[1] ̉~ */
		# ~Q̒S甼a @r[3]+@R[2] ̉~̌_ */
		# ------------------------------------------------ */
		# CCP	Q~̌_ */
		# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
		#	 Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
		#	   @TYPE */
		# ------------------------------------------------ */
		diagram_ccp.cx[1] = @cx[1]
		diagram_ccp.cy[1] = @cy[1]
		diagram_ccp.r[1] = @r[3] + @r[1]
		diagram_ccp.cx[2] = @cx[2]
		diagram_ccp.cy[2] = @cy[2]
		diagram_ccp.r[2] = @r[3] + @r[2]
		diagram_ccp.ccp

		if (diagram_ccp.Type == 1) 
			i = i + 1
			@cx[i] = diagram_ccp.sx[1]
			@cy[i] = diagram_ccp.sy[1]
			@r[i] = @r[3]
		end

		if (diagram_ccp.Type == 2) 
			i = i + 1
			@cx[i] = diagram_ccp.sx[1]
			@cy[i] = diagram_ccp.sy[1]
			@r[i] = @r[3]
			i = i + 1
			@cx[i] = diagram_ccp.sx[2]
			@cy[i] = diagram_ccp.sy[2]
			@r[i] = @r[3]
		end


		# < 3 & 4 > */
		# ------------------------------------------------ */
		# CCP	Q~̌_ */
		# (@cx[1],@CY[1]) @r[1] (@CX(2),@CY(2)) @R(2) */
		#	 Ans (@SX[1],@SY[1]) (@SX(2),@SY(2)) */
		#	   @TYPE */
		# ------------------------------------------------ */
		diagram_ccp.cx[1] = @cx[1]
		diagram_ccp.cy[1] = @cy[1]
		diagram_ccp.r[1] = @r[1]
		diagram_ccp.cx[2] = @cx[2]
		diagram_ccp.cy[2] = @cy[2]
		diagram_ccp.r[2] = @r[2]
		diagram_ccp.ccp
						
		if (diagram_ccp.Type == 1) 
			# _(diagram_ccp.sx[1],diagram_ccp.sy[1]) */
			# ------------------------------------------------ */
			# la	̊px */
			#	  (@sx[1],@sy[1]),(@ex[1],@ey[1]) */
			#		   ans @angle */
			# ------------------------------------------------ */
			diagram_la.sx[1] = diagram_ccp.sx[1]
			diagram_la.sy[1] = diagram_ccp.sy[1]
			diagram_la.ex[1] = @cx[1]
			diagram_la.ey[1] = @cy[1]
			diagram_la.la

			# 3 */
			# ------------------------------------------------ */
			# pap	n_ƊpxƋŒ̏I_߂ */
			#   (@sx[1] , @sy[1]) , @angle , @l */
			# 	   ans	(@ex[1] , @ey[1]) */
			# ------------------------------------------------ */
			diagram_pap.sx[1] = diagram_ccp.sx[1]
			diagram_pap.sy[1] = diagram_ccp.sy[1]
			diagram_pap.Angle = diagram_la.Angle
			diagram_pap.l = @r[3]
			diagram_pap.pap

			i = i + 1
			@cx[i] = diagram_pap.ex[1]
			@cy[i] = diagram_pap.ey[1]
			@r[i] = @r[3]

			# 4 */
			# ------------------------------------------------ */
			# pap	n_ƊpxƋŒ̏I_߂ */
			#   (@sx[1] , @sy[1]) , @angle , @l */
			# 	   ans	(@ex[1] , @ey[1]) */
			# ------------------------------------------------ */
			diagram_pap.sx[1] = diagram_ccp.sx[1]
			diagram_pap.sy[1] = diagram_ccp.sy[1]
			diagram_pap.Angle = (diagram_la.Angle + 180)
			diagram_pap.l = @r[3]
			diagram_pap.pap

			i = i + 1
			@cx[i] = diagram_pap.ex[1]
			@cy[i] = diagram_pap.ey[1]
			@r[i] = @r[3]
		end



		# < 5 & 6 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length + @r[1] + @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[3]-@R[1] ̉~ */
			# ~Q̒S甼a @r[3]-@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#    @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] - @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] - @r[2]
			diagram_ccp.ccp

			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end
	end





	# B ~PƉ~QdȂĂB---------------------------------- */
	if ((sg(diagram_pp.Length, CALCU_DIGITS) < sg(@r[1] + @r[2], CALCU_DIGITS)) && (sg(diagram_pp.Length, CALCU_DIGITS) > sg(@r[2] - @r[1], CALCU_DIGITS)))
		# < 1 & 2 >  ΂ */
		# ~P̒S甼a @r[3]+@R[1] ̉~ */
		# ~Q̒S甼a @r[3]+@R[2] ̉~̌_ */
		# ------------------------------------------------ */
		# CCP	Q~̌_ */
		# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
		#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
		#    @TYPE */
		# ------------------------------------------------ */
		diagram_ccp.cx[1] = @cx[1]
		diagram_ccp.cy[1] = @cy[1]
		diagram_ccp.r[1] = @r[3] + @r[1]
		diagram_ccp.cx[2] = @cx[2]
		diagram_ccp.cy[2] = @cy[2]
		diagram_ccp.r[2] = @r[3] + @r[2]
		diagram_ccp.ccp
						
		if (diagram_ccp.Type == 1) 
			i = i + 1
			@cx[i] = diagram_ccp.sx[1]
			@cy[i] = diagram_ccp.sy[1]
			@r[i] = @r[3]
		end
			
		if (diagram_ccp.Type == 2) 
			i = i + 1
			@cx[i] = diagram_ccp.sx[1]
			@cy[i] = diagram_ccp.sy[1]
			@r[i] = @r[3]
			i = i + 1
			@cx[i] = diagram_ccp.sx[2]
			@cy[i] = diagram_ccp.sy[2]
			@r[i] = @r[3]
		end



		# < 3 & 4 > */
		if (sg(2 * @r[3], CALCU_DIGITS) <= sg(diagram_pp.Length - @r[2] + @r[1], CALCU_DIGITS)) 
			# ~P̒S甼a @r[1]-@R[3] ̉~ */
			# ~Q̒S甼a @r[3]+@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#    @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] - @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] + @r[2]
			diagram_ccp.ccp

			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 5 & 6 > */
		if (sg(2 * @r[3], CALCU_DIGITS) <= sg(diagram_pp.Length - @r[1] + @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[1]+@R[3] ̉~ */
			# ~Q̒S甼a @r[2]-@R[3] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#    @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] + @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] - @r[3]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 7 & 8 > */
		if (sg(2 * @r[3], CALCU_DIGITS) <= sg(@r[1] + @r[2] - diagram_pp.Length, CALCU_DIGITS)) 
			# ~P̒S甼a @r[1]-@R[3] ̉~ */
			# ~Q̒S甼a @r[2]-@R[3] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#    @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] - @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] - @r[3]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 9 & 10 > */
		if (sg(2 * @r[3], CALCU_DIGITS) >= sg(diagram_pp.Length + @r[1] + @r[2], CALCU_DIGITS)) 
			# ~P̒S甼a @r[3]-@R[1] ̉~ */
			# ~Q̒S甼a @r[3]-@R[2] ̉~̌_ */
			# ------------------------------------------------ */
			# CCP	Q~̌_ */
			# (@cx[1],@CY[1]) @r[1] (@CX[2],@cy[2]) @R[2] */
			#  Ans (@SX[1],@SY[1]) (@SX[2],@SY[2]) */
			#    @TYPE */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] - @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[3] - @r[2]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end
	end





	# C ~Q̒ɉ~PĐڂĂB-------------------------- */
	if (sg(diagram_pp.Length, CALCU_DIGITS) == sg(@r[2] - @r[1], CALCU_DIGITS) && sg(@r[2], CALCU_DIGITS) != sg(@r[1], CALCU_DIGITS))
		# < 1 & 2 > */
		# ------------------------------------------------ */
		# ccp	Q~̌_ */
		# (@cx[1],@cy[1]) @r[1] (@cx[2],@cy[2]) @r[2] */
		#  ans (@sx[1],@sy[1]) (@sx[2],@sy[2]) */
		#    @Type */
		# ------------------------------------------------ */
		diagram_ccp.cx[1] = @cx[1]
		diagram_ccp.cy[1] = @cy[1]
		diagram_ccp.r[1] = @r[1]
		diagram_ccp.cx[2] = @cx[2]
		diagram_ccp.cy[2] = @cy[2]
		diagram_ccp.r[2] = @r[2]
		diagram_ccp.ccp
						
		# _(diagram_ccp.sx[1],diagram_ccp.sy[1]) */
		# ------------------------------------------------ */
		# la	̊px */
		#   (@sx[1],@sy[1]),(@ex[1],@ey[1]) */
		# 	   ans @angle */
		# ------------------------------------------------ */
		diagram_la.sx[1] = diagram_ccp.sx[1]
		diagram_la.sy[1] = diagram_ccp.sy[1]
		diagram_la.ex[1] = @cx[1]
		diagram_la.ey[1] = @cy[1]
		diagram_la.la
			
		# 3 */
		# ------------------------------------------------ */
		# pap	n_ƊpxƋŒ̏I_߂ */
		#   (@sx[1] , @sy[1]) , @angle , @l */
		# 	   ans	(@ex[1] , @ey[1]) */
		# ------------------------------------------------ */
		diagram_pap.sx[1] = diagram_ccp.sx[1]
		diagram_pap.sy[1] = diagram_ccp.sy[1]
		diagram_pap.Angle = diagram_la.Angle
		diagram_pap.l = @r[3]
		diagram_pap.pap
			
		i = i + 1
		@cx[i] = diagram_pap.ex[1]
		@cy[i] = diagram_pap.ey[1]
		@r[i] = @r[3]
		
		# 4 */
		# ------------------------------------------------ */
		# pap	n_ƊpxƋŒ̏I_߂ */
		#   (@sx[1] , @sy[1]) , @angle , @l */
		# 	   ans	(@ex[1] , @ey[1]) */
		# ------------------------------------------------ */
		diagram_pap.sx[1] = diagram_ccp.sx[1]
		diagram_pap.sy[1] = diagram_ccp.sy[1]
		diagram_pap.Angle = (diagram_la.Angle + 180)
		diagram_pap.l = @r[3]
		diagram_pap.pap
			
		i = i + 1
		@cx[i] = diagram_pap.ex[1]
		@cy[i] = diagram_pap.ey[1]
		@r[i] = @r[3]



		# < 3 & 4 > */
		if (sg(2 * @r[3], CALCU_DIGITS) <= sg(2 * @r[2] - 2 * @r[1], CALCU_DIGITS)) 
			# ~P̒S甼a @r[1]+@r[3] ̉~ */
			# ~Q̒S甼a @r[2]-@r[3] ̉~̌_ */
			# ------------------------------------------------ */
			# ccp	Q~̌_ */
			# (@cx[1],@cy[1]) @r[1] (@cx[2],@cy[2]) @r[2] */
			#  ans (@sx[1],@sy[1]) (@sx[2],@sy[2]) */
			#    @Type */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] + @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] - @r[3]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end
	end



	# D ~Q̒ɉ~PėĂB-------------------------- */
	if (sg(diagram_pp.Length, CALCU_DIGITS) < sg(@r[2] - @r[1], CALCU_DIGITS) && sg(@r[2], CALCU_DIGITS) != sg(@r[1], CALCU_DIGITS))
		# < 1 & 2 > */
		if ((sg(2 * @r[3], CALCU_DIGITS) >= sg(@r[2] - diagram_pp.Length - @r[1], CALCU_DIGITS)) && (sg(2 * @r[3], CALCU_DIGITS) <= sg(@r[2] + diagram_pp.Length - @r[1], CALCU_DIGITS)))
			# ~P̒S甼a @r[1]+@r[3] ̉~ */
			# ~Q̒S甼a @r[2]-@r[3] ̉~̌_ */
			# ------------------------------------------------ */
			# ccp	Q~̌_ */
			# (@cx[1],@cy[1]) @r[1] (@cx[2],@cy[2]) @r[2] */
			#  ans (@sx[1],@sy[1]) (@sx[2],@sy[2]) */
			#    @Type */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[1] + @r[3]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] - @r[3]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end



		# < 3 & 4 > */
		if ((sg(2 * @r[3], CALCU_DIGITS) >= sg(@r[2] - diagram_pp.Length + @r[1], CALCU_DIGITS)) && (sg(2 * @r[3], CALCU_DIGITS) <= sg(@r[2] + diagram_pp.Length + @r[1], CALCU_DIGITS)))
			# ~P̒S甼a @r[3]-@r[1] ̉~ */
			# ~Q̒S甼a @r[2]-@r[3] ̉~̌_ */
			# ------------------------------------------------ */
			# ccp	Q~̌_ */
			# (@cx[1],@cy[1]) @r[1] (@cx[2],@cy[2]) @r[2] */
			#  ans (@sx[1],@sy[1]) (@sx[2],@sy[2]) */
			#    @Type */
			# ------------------------------------------------ */
			diagram_ccp.cx[1] = @cx[1]
			diagram_ccp.cy[1] = @cy[1]
			diagram_ccp.r[1] = @r[3] - @r[1]
			diagram_ccp.cx[2] = @cx[2]
			diagram_ccp.cy[2] = @cy[2]
			diagram_ccp.r[2] = @r[2] - @r[3]
			diagram_ccp.ccp
						
			if (diagram_ccp.Type == 1) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
			end
			
			if (diagram_ccp.Type == 2) 
				i = i + 1
				@cx[i] = diagram_ccp.sx[1]
				@cy[i] = diagram_ccp.sy[1]
				@r[i] = @r[3]
				i = i + 1
				@cx[i] = diagram_ccp.sx[2]
				@cy[i] = diagram_ccp.sy[2]
				@r[i] = @r[3]
			end
		end
	end



	i = i - 2
	@Type = i

	return 1
end



# -------------------------------------------------------------------
#  : R_ʂ~
# ֐ : pppc()
#  : struct RtnDat *a
# 	:	( a->sx[1] , a->sy[1] )
# 	:	( a->sx[2] , a->sy[2] )
# 	:	( a->sx[3] , a->sy[3] )
# ߒl : int
# 	:	(a->cx[1],a->cy[1]),a->r[1]
# O : 
#  : 
# l : Ql	[Visual Basic ɂ CG] L  YƐ}
def pppc()

	eps = 0.000001

	x1 = @sx[1]
	y1 = @sy[1]

	x2 = @sx[2]
	y2 = @sy[2]

	f1 = x2 - x1
	g1 = y2 - y1
	fg1 = f1*f1 + g1*g1
	if (fg1 < eps) 
		print "R_ŉ~ : G[ : _ł"
		return 0
	end

	# _̌vZ */
	xa = x1 + f1/2
	ya = y1 + g1/2
	# L1̌W */
	a1 = -g1
	b1 = f1
	c1 = x1*g1 - y1*f1
	# L11̌W */
	a11 = b1
	b11 = -a1
	c11 = a1*ya - b1*xa

	x3 = @sx[3]
	y3 = @sy[3]

	f2 = x3 - x2
	g2 = y3 - y2
	fg2 = f2*f2 + g2*g2
	if (fg2 < eps) 
		print "R_ŉ~ : G[ : _ł"
		return 0
	end


	f3 = x3 - x1
	g3 = y3 - y1
	fg3 = f3*f3 + g3*g3
	if (fg3 < eps) 
		print "R_ŉ~ : G[ : _ł"
		return 0
	end

	# _̌vZ */
	xb = x2 + f2/2
	yb = y2 + g2/2
	# L2̌W */
	a2 = -g2
	b2 = f2
	c2 = x2*g2 - y2*f2
	# L22̌W */
	a22 = b2
	b22 = -a2
	c22 = a2*yb - b2*xb

	dev = a11*b22 - a22*b11
	# ŠvZ */
	xc = (b11*c22 - b22*c11) / dev
	yc = (a22*c11 - a11*c22) / dev
	# ǎvZ */
	r = sqrt( (xc-x1)*(xc-x1) + (yc-y1)*(yc-y1) )


	@cx[1] = xc
	@cy[1] = yc
	@r[1]	= r
	return 1
end



# -------------------------------------------------------------------
# Rӂɐڂ~
# lllc()
#  : 
#      : 1     (a->sx[1],a->sy[1]) - (a->ex[1],a->ey[1])
#      : 2     (a->sx[2],a->sy[2]) - (a->ex[2],a->ey[2])
#      : 3     (a->sx[3],a->sy[3]) - (a->ex[3],a->ey[3])
# ߒl : @Ttype = 0,2,4   
#      : ~1     (a->cx[1],a->cy[1]),a->r[1]
#      : ~2     (a->cx[2],a->cy[2]),a->r[2]
#      : ~3     (a->cx[3],a->cy[3]),a->r[3]
#      : ~4     (a->cx[4],a->cy[4]),a->r[4]
# l : Ql	[Visual Basic ɂ CG] L  YƐ}
#
# 1FS	ʂ */
# 2FQ	Qs */
# 0FO	Rs */
# ------------------------------------------------ */
# R̂QsȂÂQ甼a߂āA */
# QɕsŐ^񒆂̒lɉ~̒S邩A̒ */
# lƂR{ڂ̒̌_߂āǍ_璼ĺ}̂Q */
# ɔaꂽ_~̒SB */
def lllc()

	diagram_ppp = Diagram.new
	diagram_pap = Diagram.new
	diagram_lo = Diagram.new
	diagram_lll = Diagram.new
	diagram_llp = Diagram.new
	diagram_plp = Diagram.new
	diagram_pp = Diagram.new
	diagram_la = Diagram.new


	ax = 0
	ay = 0
	bx = 0
	by = 0
	fx = 0
	fy = 0


	# --- < O > ---------------------------------------------------------- */



	# ----------------------------------------------------- */
	# --- < e̊px߂B > ---------------------- */
	# --- */
	# --- */

	# P̊px߂B */
	diagram_la.sx[1] = @sx[1]
	diagram_la.sy[1] = @sy[1]
	diagram_la.ex[1] = @ex[1]
	diagram_la.ey[1] = @ey[1]
	diagram_la.la
	la1 = diagram_la.Angle
	if (la1 > 180) 
		la1 = La1 - 180
	end

	# Q̊px߂B */
	diagram_la.sx[1] = @sx[2]
	diagram_la.sy[1] = @sy[2]
	diagram_la.ex[1] = @ex[2]
	diagram_la.ey[1] = @ey[2]
	diagram_la.la
	la2 = diagram_la.Angle
	if (la2 > 180) 
		la2 = La2 - 180
	end

	# R̊px߂B */
	diagram_la.sx[1] = @sx[3]
	diagram_la.sy[1] = @sy[3]
	diagram_la.ex[1] = @ex[3]
	diagram_la.ey[1] = @ey[3]
	diagram_la.la
	la3 = diagram_la.Angle
	if (la3 > 180) 
		la3 = La3 - 180
	end



	# ----------------------------------------------------- */
	# --- < pxŎ̏𔻒肷B > ------------------ */
	# --- */
	# --- */

	# RƂs */
	if (sg(la1, COMPA_DIGITS) == sg(la2, COMPA_DIGITS) && sg(la1, COMPA_DIGITS) == sg(la3, COMPA_DIGITS)) 
		@Type = 0
		return 0
	end

	# Qs */
	if (sg(la1, COMPA_DIGITS) == sg(la2, COMPA_DIGITS) || sg(la1, COMPA_DIGITS) == sg(la3, COMPA_DIGITS) || sg(la2, COMPA_DIGITS) == sg(la3, COMPA_DIGITS)) 
		@Type = 2
	else 
		@Type = 4
	end
	# --- < O > ---------------------------------------------------------- */



	# --- < QsB> --------------------------------------------------- */
	if (@Type == 2) 
		# 1ƒ2sɂȂ悤Ƀf[^ւB */
		if (sg(la1, COMPA_DIGITS) == sg(la2, COMPA_DIGITS)) 
			# OK */
		elsif (sg(la1, COMPA_DIGITS) == sg(la3, COMPA_DIGITS)) 
			# 23ւB */
			dumy = la3
			la3 = La2
			la2 = dumy	
			dumy = @sx[3]
			@sx[3] = @sx[2]
			@sx[2] = dumy
			dumy = @sy[3]
			@sy[3] = @sy[2]
			@sy[2] = dumy
			dumy = @ex[3]
			@ex[3] = @ex[2]
			@ex[2] = dumy
			dumy = @ey[3]
			@ey[3] = @ey[2]
			@ey[2] = dumy
		elsif (sg(la2, COMPA_DIGITS) == sg(la3, COMPA_DIGITS)) 
			# 13ւB */
			dumy = la3
			la3 = La1
			la1 = dumy
			dumy = @sx[3]
			@sx[3] = @sx[1]
			@sx[1] = dumy
			dumy = @sy[3]
			@sy[3] = @sy[1]
			@sy[1] = dumy
			dumy = @ex[3]
			@ex[3] = @ex[1]
			@ex[1] = dumy
			dumy = @ey[3]
			@ey[3] = @ey[1]
			@ey[1] = dumy
		end


		# --- <  1 ƒ 2 ̋߂B> ----------------------------- */
		#  1 ̎n_ƒ 2 ̍ŋߓ_߂B */
		diagram_plp.sx[2] = @sx[1]
		diagram_plp.sy[2] = @sy[1]
		diagram_plp.sx[1] = @sx[2]
		diagram_plp.sy[1] = @sy[2]
		diagram_plp.ex[1] = @ex[2]
		diagram_plp.ey[1] = @ey[2]
		plp(&diagram_plp) # ( diagram_plp.ex[2] , diagram_plp.ey[2] ) */

		#  1 ̎n_ƒ 2 ̍ŋߓ_̋߁Aa R ߂B */
		diagram_pp.sx[1] = @sx[1]
		diagram_pp.sy[1] = @sy[1]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp
		@r[1] = diagram_pp.Length / 2
		@r[2] = diagram_pp.Length / 2

		#  1 ̎n_ƒ 2 ̍ŋߓ_̒_߁A_璼 1ƕsȒ 4߂B */
		diagram_ppp.sx[1] = @sx[1]
		diagram_ppp.sy[1] = @sy[1]
		diagram_ppp.ex[1] = diagram_plp.ex[2]
		diagram_ppp.ey[1] = diagram_plp.ey[2]
		diagram_ppp.sx[2] = 1
		diagram_ppp.ex[2] = 1
		diagram_ppp.ppp
		# _   4 ̎n_( diagram_ppp.sx[3] , diagram_ppp.sy[3]) */

		diagram_pap.sx[1] = diagram_ppp.sx[3]
		diagram_pap.sy[1] = diagram_ppp.sy[3]
		diagram_pap.Angle = la1
		diagram_pap.Length = 50
		diagram_pap.pap
		#  4 ̏I_( diagram_pap.ex[1] , diagram_pap.ey[1]) */

		#  4 ƒ 3 ̌_ 5 ߂B */
		diagram_llp.sx[1] = diagram_ppp.sx[3]
		diagram_llp.sy[1] = diagram_ppp.sy[3]
		diagram_llp.ex[1] = diagram_pap.ex[1]
		diagram_llp.ey[1] = diagram_pap.ey[1]
		diagram_llp.sx[2] = @sx[3]
		diagram_llp.sy[2] = @sy[3]
		diagram_llp.ex[2] = @ex[3]
		diagram_llp.ey[2] = @ey[3]
		diagram_llp.llp
		# _ 5( diagram_llp.sx[3] , diagram_llp.sy[3] ) */



		#  3 ItZbg 5,6 ߂B */
		# ------------------------------------------------------------------- */
		#  : n_ƏI_^̃ItZbg */
		# ------------------------------------------------------------------- */
		diagram_lo.sx[1] = @sx[3]
		diagram_lo.sy[1] = @sy[3]
		diagram_lo.ex[1] = @ex[3]
		diagram_lo.ey[1] = @ey[3]
		diagram_lo.Length = @r[1]
		diagram_lo.lo
		# (diagram_lo.sx[2] , diagram_lo.sy[2]) - (diagram_lo.ex[2] , diagram_lo.ey[2]) */
		# (diagram_lo.sx[3] , diagram_lo.sy[3]) - (diagram_lo.ex[3] , diagram_lo.ey[3]) */

		#  5,6 ƒ 4 ̌_ */
		# ------------------------------------------------------------------- */
		#  : Q̌_	߂ẴOtBbNX P120 */
		# ------------------------------------------------------------------- */
		diagram_llp.sx[1] = diagram_lo.sx[2]
		diagram_llp.sy[1] = diagram_lo.sy[2]
		diagram_llp.ex[1] = diagram_lo.ex[2]
		diagram_llp.ey[1] = diagram_lo.ey[2]

		diagram_llp.sx[2] = diagram_ppp.sx[3]
		diagram_llp.sy[2] = diagram_ppp.sy[3]
		diagram_llp.ex[2] = diagram_pap.ex[1]
		diagram_llp.ey[2] = diagram_pap.ey[1]
		diagram_llp.llp
		@cx[1] = diagram_llp.sx[3]
		@cy[1] = diagram_llp.sy[3]


		diagram_llp.sx[1] = diagram_lo.sx[3]
		diagram_llp.sy[1] = diagram_lo.sy[3]
		diagram_llp.ex[1] = diagram_lo.ex[3]
		diagram_llp.ey[1] = diagram_lo.ey[3]

		diagram_llp.sx[2] = diagram_ppp.sx[3]
		diagram_llp.sy[2] = diagram_ppp.sy[3]
		diagram_llp.ex[2] = diagram_pap.ex[1]
		diagram_llp.ey[2] = diagram_pap.ey[1]
		diagram_llp.llp
		@cx[2] = diagram_llp.sx[3]
		@cy[2] = diagram_llp.sy[3]
		return 1
	end
	# --- < QsB> --------------------------------------------------- */





	# --- < RӂsłȂB> ----------------------------------------------- */
	if (@Type == 4) 
		# ----------------------------------------------------- */
		# --- < Rӂ̌_߂B > ------------------------ */
		# --- */
		# --- */

		# ***	PƒQ̌_`߂B */
		diagram_llp.sx[1] = @sx[1]
		diagram_llp.sy[1] = @sy[1]
		diagram_llp.ex[1] = @ex[1]
		diagram_llp.ey[1] = @ey[1]
		diagram_llp.sx[2] = @sx[2]
		diagram_llp.sy[2] = @sy[2]
		diagram_llp.ex[2] = @ex[2]
		diagram_llp.ey[2] = @ey[2]
		diagram_llp.llp
		# =0 Ȃ畽s */
		if (diagram_llp.Type != 0) 
			ax = diagram_llp.sx[3]
			ay = diagram_llp.sy[3]
		end

		# ***	QƒŘ_a߂B */
		diagram_llp.sx[1] = @sx[2]
		diagram_llp.sy[1] = @sy[2]
		diagram_llp.ex[1] = @ex[2]
		diagram_llp.ey[1] = @ey[2]
		diagram_llp.sx[2] = @sx[3]
		diagram_llp.sy[2] = @sy[3]
		diagram_llp.ex[2] = @ex[3]
		diagram_llp.ey[2] = @ey[3]
		diagram_llp.llp
		if (diagram_llp.Type != 0) 
			bx = diagram_llp.sx[3]
			by = diagram_llp.sy[3]
		end

		# ***	RƒP̌_e߂B */
		diagram_llp.sx[1] = @sx[3]
		diagram_llp.sy[1] = @sy[3]
		diagram_llp.ex[1] = @ex[3]
		diagram_llp.ey[1] = @ey[3]
		diagram_llp.sx[2] = @sx[1]
		diagram_llp.sy[2] = @sy[1]
		diagram_llp.ex[2] = @ex[1]
		diagram_llp.ey[2] = @ey[1]
		diagram_llp.llp
		if (diagram_llp.Type != 0) 
			fx = diagram_llp.sx[3]
			fy = diagram_llp.sy[3]
		end


		if (sg(ax, COMPA_DIGITS) == sg(BX, COMPA_DIGITS) && sg(BX, COMPA_DIGITS) == sg(fx, COMPA_DIGITS) && sg(ay, COMPA_DIGITS) == sg(by, COMPA_DIGITS) && sg(by, COMPA_DIGITS) == sg(fy, COMPA_DIGITS)) 
			@Type = 0
			return -1
		end



		# ----------------------------------------------------- */
		# --- < 1 > --------------------------------------- */
		# --- */
		# --- */

		# `_n_ƂQ̂Q`(sxa,SYA)-(exa,EYA)߂  --- */
		diagram_lll.sx[1] = ax
		diagram_lll.sy[1] = ay
		diagram_lll.ex[1] = bx
		diagram_lll.ey[1] = by 
		diagram_lll.sx[2] = ax
		diagram_lll.sy[2] = ay
		diagram_lll.ex[2] = fx
		diagram_lll.ey[2] = fy
		diagram_lll.lll
		sxa = diagram_lll.sx[3]
		sya = diagram_lll.sy[3]
		exa = diagram_lll.ex[3]
		eya = diagram_lll.ey[3]

		# a_n_ƂQ̂Qa(sxb,SYB)-(exb,EYB)߂  --- */
		diagram_lll.sx[1] = bx
		diagram_lll.sy[1] = by
		diagram_lll.ex[1] = ax
		diagram_lll.ey[1] = ay
		diagram_lll.sx[2] = bx
		diagram_lll.sy[2] = by
		diagram_lll.ex[2] = fx
		diagram_lll.ey[2] = fy
		diagram_lll.lll
		sxb = diagram_lll.sx[3]
		syb = diagram_lll.sy[3]
		exb = diagram_lll.ex[3]
		eyb = diagram_lll.ey[3]


		# Q`ƂQǎ_߂B߂~̒S(CX,CY)	--- */
		diagram_llp.sx[1] = sxa
		diagram_llp.sy[1] = sya
		diagram_llp.ex[1] = exa
		diagram_llp.ey[1] = eya
		diagram_llp.sx[2] = sxb
		diagram_llp.sy[2] = syb
		diagram_llp.ex[2] = exb
		diagram_llp.ey[2] = eyb
		diagram_llp.llp
		@cx[1] = diagram_llp.sx[3]
		@cy[1] = diagram_llp.sy[3]

		# S璼P܂ł̋߂B߂~̔a R	--- */
		diagram_plp.sx[2] = @cx[1]
		diagram_plp.sy[2] = @cy[1]
		diagram_plp.sx[1] = @sx[1]
		diagram_plp.sy[1] = @sy[1]
		diagram_plp.ex[1] = @ex[1]
		diagram_plp.ey[1] = @ey[1]
		diagram_plp.plp
		#  --- */
		diagram_pp.sx[1] = @cx[1]
		diagram_pp.sy[1] = @cy[1]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp
		@r[1] = diagram_pp.Length



		# ----------------------------------------------------- */
		# --- < 2 > --------------------------------------- */
		# --- */
		# --- */

		# `_n_ƏI_ƂQ̂Q`(sxa,SYA)-(exa,EYA)߂	--- */
		diagram_lll.sx[1] = fx
		diagram_lll.sy[1] = fy
		diagram_lll.ex[1] = ax
		diagram_lll.ey[1] = ay
		diagram_lll.sx[2] = ax
		diagram_lll.sy[2] = ay
		diagram_lll.ex[2] = bx
		diagram_lll.ey[2] = by
		diagram_lll.lll
		sxa = diagram_lll.sx[3]
		sya = diagram_lll.sy[3]
		exa = diagram_lll.ex[3]
		eya = diagram_lll.ey[3]

		# a_n_ƏI_ƂQ̂Qa(sxb,SYB)-(exb,EYB)߂	--- */
		diagram_lll.sx[1] = fx
		diagram_lll.sy[1] = fy
		diagram_lll.ex[1] = bx
		diagram_lll.ey[1] = by
		diagram_lll.sx[2] = bx
		diagram_lll.sy[2] = by
		diagram_lll.ex[2] = ax
		diagram_lll.ey[2] = ay
		diagram_lll.lll
		sxb = diagram_lll.sx[3]
		syb = diagram_lll.sy[3]
		exb = diagram_lll.ex[3]
		eyb = diagram_lll.ey[3]


		# Q`ƂQǎ_߂B߂~̒S(CX,CY)	--- */
		diagram_llp.sx[1] = sxa
		diagram_llp.sy[1] = sya
		diagram_llp.ex[1] = exa
		diagram_llp.ey[1] = eya
		diagram_llp.sx[2] = sxb
		diagram_llp.sy[2] = syb
		diagram_llp.ex[2] = exb
		diagram_llp.ey[2] = eyb
		diagram_llp.llp
		@cx[2] = diagram_llp.sx[3]
		@cy[2] = diagram_llp.sy[3]

		# S璼P܂ł̋߂B߂~̔a R	--- */
		diagram_plp.sx[2] = @cx[2]
		diagram_plp.sy[2] = @cy[2]
		diagram_plp.sx[1] = @sx[1]
		diagram_plp.sy[1] = @sy[1]
		diagram_plp.ex[1] = @ex[1]
		diagram_plp.ey[1] = @ey[1]
		diagram_plp.plp
		#  --- */
		diagram_pp.sx[1] = @cx[2]
		diagram_pp.sy[1] = @cy[2]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp
		@r[2] = diagram_pp.Length



		# ----------------------------------------------------- */
		# --- < 3 > --------------------------------------- */
		# --- */
		# --- */

		# B _n_ƏI_ƂQ̂Q`(sxa,SYA)-(exa,EYA)߂	--- */
		diagram_lll.sx[1] = ax
		diagram_lll.sy[1] = ay
		diagram_lll.ex[1] = bx
		diagram_lll.ey[1] = by
		diagram_lll.sx[2] = bx
		diagram_lll.sy[2] = by
		diagram_lll.ex[2] = fx
		diagram_lll.ey[2] = fy
		diagram_lll.lll
		sxa = diagram_lll.sx[3]
		sya = diagram_lll.sy[3]
		exa = diagram_lll.ex[3]
		eya = diagram_lll.ey[3]

		# F _n_ƏI_ƂQ̂Qa(sxb,SYB)-(exb,EYB)߂	--- */
		diagram_lll.sx[1] = ax
		diagram_lll.sy[1] = ay
		diagram_lll.ex[1] = fx
		diagram_lll.ey[1] = fy
		diagram_lll.sx[2] = fx
		diagram_lll.sy[2] = fy
		diagram_lll.ex[2] = bx
		diagram_lll.ey[2] = by
		diagram_lll.lll
		sxb = diagram_lll.sx[3]
		syb = diagram_lll.sy[3]
		exb = diagram_lll.ex[3]
		eyb = diagram_lll.ey[3]


		# Q`ƂQǎ_߂B߂~̒S(CX,CY)	--- */
		diagram_llp.sx[1] = sxa
		diagram_llp.sy[1] = sya
		diagram_llp.ex[1] = exa
		diagram_llp.ey[1] = eya
		diagram_llp.sx[2] = sxb
		diagram_llp.sy[2] = syb
		diagram_llp.ex[2] = exb
		diagram_llp.ey[2] = eyb
		diagram_llp.llp
		@cx[3] = diagram_llp.sx[3]
		@cy[3] = diagram_llp.sy[3]

		# S璼P܂ł̋߂B߂~̔a R	--- */
		diagram_plp.sx[2] = @cx[3]
		diagram_plp.sy[2] = @cy[3]
		diagram_plp.sx[1] = @sx[1]
		diagram_plp.sy[1] = @sy[1]
		diagram_plp.ex[1] = @ex[1]
		diagram_plp.ey[1] = @ey[1]
		diagram_plp.plp
		#  --- */
		diagram_pp.sx[1] = @cx[3]
		diagram_pp.sy[1] = @cy[3]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp
		@r[3] = diagram_pp.Length



		# ----------------------------------------------------- */
		# --- < 4 > --------------------------------------- */
		# --- */
		# --- */

		# F _n_ƏI_ƂQ̂Q`(sxa,SYA)-(exa,EYA)߂	--- */
		diagram_lll.sx[1] = bx
		diagram_lll.sy[1] = by
		diagram_lll.ex[1] = fx
		diagram_lll.ey[1] = fy
		diagram_lll.sx[2] = fx
		diagram_lll.sy[2] = fy
		diagram_lll.ex[2] = ax
		diagram_lll.ey[2] = ay
		diagram_lll.lll
		sxa = diagram_lll.sx[3]
		sya = diagram_lll.sy[3]
		exa = diagram_lll.ex[3]
		eya = diagram_lll.ey[3]

		# A _n_ƏI_ƂQ̂Qa(sxb,SYB)-(exb,EYB)߂	--- */
		diagram_lll.sx[1] = bx
		diagram_lll.sy[1] = by
		diagram_lll.ex[1] = ax
		diagram_lll.ey[1] = ay
		diagram_lll.sx[2] = ax
		diagram_lll.sy[2] = ay
		diagram_lll.ex[2] = fx
		diagram_lll.ey[2] = fy
		diagram_lll.lll
		sxb = diagram_lll.sx[3]
		syb = diagram_lll.sy[3]
		exb = diagram_lll.ex[3]
		eyb = diagram_lll.ey[3]

		# Q`ƂQǎ_߂B߂~̒S(CX,CY)	--- */
		diagram_llp.sx[1] = sxa
		diagram_llp.sy[1] = sya
		diagram_llp.ex[1] = exa
		diagram_llp.ey[1] = eya
		diagram_llp.sx[2] = sxb
		diagram_llp.sy[2] = syb
		diagram_llp.ex[2] = exb
		diagram_llp.ey[2] = eyb
		diagram_llp.llp
		@cx[4] = diagram_llp.sx[3]
		@cy[4] = diagram_llp.sy[3]

		# S璼P܂ł̋߂B߂~̔a R	--- */
		diagram_plp.sx[2] = @cx[4]
		diagram_plp.sy[2] = @cy[4]
		diagram_plp.sx[1] = @sx[1]
		diagram_plp.sy[1] = @sy[1]
		diagram_plp.ex[1] = @ex[1]
		diagram_plp.ey[1] = @ey[1]
		diagram_plp.plp
		#  --- */
		diagram_pp.sx[1] = @cx[4]
		diagram_pp.sy[1] = @cy[4]
		diagram_pp.ex[1] = diagram_plp.ex[2]
		diagram_pp.ey[1] = diagram_plp.ey[2]
		diagram_pp.pp
		@r[4] = diagram_pp.Length
		return 1
	end
	return 0
end









end
__END__





# -------------------------------------------------------------------
#  : _~̒ɂ邩Oɂ邩B
# ֐ : ChkPointCircleSide
#  : struct RtnDat *
# 	:	(a->sx[1] , a->sy[1]) 
# 	:	(a->cx[1] , a->cy[1]) , a->r[1]
# ߒl : int	 a->type = 0FERR	1F	2FO	3F
# O : 
#  :
 */
int ChkPointCircleSide(struct RtnDat *a)
{
	struct RtnDat PPH


	PPH.sx[1] = a->sx[1]
	PPH.sy[1] = a->sy[1]
	PPH.ex[1] = a->cx[1]
	PPH.ey[1] = a->cy[1]
	pp(&PPH)

	if (sg(PPH.l, CALCU_DIGITS) == sg(a->r[1], CALCU_DIGITS))	  a->type = 0
	else if (sg(PPH.l, CALCU_DIGITS) < sg(a->r[1], CALCU_DIGITS)) a->type = 1
	else if (sg(PPH.l, CALCU_DIGITS) > sg(a->r[1], CALCU_DIGITS)) a->type = 2

	return 1
}



# -------------------------------------------------------------------
#  : _̐is̉E(1)ɂ邩A(2)ɂ邩H
# ֐ : ChkPointLineSide
#  : struct RtnDat *
# 	:	( a->sx[1] , a->sy[1] )-( a->ex[1] , a->ey[1] )
# 	:	( a->sx[2] , a->sy[2] )
# ߒl : int
# 	:	a->type = 0FERR	1FE	 2F	  3F
# O : 
#  : 
int ChkPointLineSide(struct RtnDat *a)
{
	struct RtnDat PLPH, LAH
	double Ang1, Ang2, Dumy


	a->type = 0

	# --- < ŋߓ_߂B > --- */
	PLPH = *a
	plp(&PLPH)
	# ŋߓ_	(PLPH.ex[2],PLPH.ey[2]) */

	if (a->sx[2] == PLPH.ex[2] && a->sy[2] == PLPH.ey[2]) {
		a->type = 3
		return 1
	}

	# --- < ̊px > --- */
	LAH.sx[1] = a->sx[1]
	LAH.sy[1] = a->sy[1]
	LAH.ex[1] = a->ex[1]
	LAH.ey[1] = a->ey[1]
	la(&LAH)
	Ang1 = LAH.Angle
		
	# --- < ŋߓ__܂ł̊px > --- */
	LAH.sx[1] = PLPH.ex[2]
	LAH.sy[1] = PLPH.ey[2]
	LAH.ex[1] = a->sx[2]
	LAH.ey[1] = a->sy[2]
	la(&LAH)
	Ang2 = LAH.Angle
	
	# is̔ */
	Dumy = Ang1 + 90
	if (Dumy >= 360)	Dumy = Dumy - 360
	if (sg(Dumy, CALCU_DIGITS) <= sg(Ang2, CALCU_DIGITS)+1	&& sg(Dumy, CALCU_DIGITS) >= sg(Ang2, CALCU_DIGITS)-1)  a->type = 2
	else a->type = 1

	return 1
}



# -------------------------------------------------------------------
#  : Ɖ~̌_(NbN_ɋ߂P_)
# ֐ : LCP1
#  : struct RtnDat *
# 	:	(a->sx[1] , a->sy[1])-(a->ex[1] , a->ey[1])
# 	:	(a->cx[1] , a->CY[1]) , a->R[1]
# 	:	(a->sx[4] , a->SY[4]) , (a->ex[4] , a->EY[4])  NbN_
# ߒl : int
# 	:	(a->sx[2] , a->SY[2])
# O : 
#  : 
int LCP1(struct RtnDat *a)
{
	struct RtnDat PPH
	double P1X, P1Y, P2X, P2Y, L1, L2
	double Ck1X, Ck1Y, Ck2X, Ck2Y


	# NbN_ */
	Ck1X = a->sx[4]
	Ck1Y = a->sy[4]
	Ck2X = a->ex[4]
	Ck2Y = a->ey[4]

	# _߂B */
	lcp(a)

	if (a->type == 0)	return 0
	else if (a->type == 1)	return 1


	else if (a->type == 2) {
		# _Q P1(a->sx[2],a->sy[2]) P2(a->sx[3],a->sy[3]) */
		P1X = a->sx[2]
		P1Y = a->sy[2]
		P2X = a->sx[3]
		P2Y = a->sy[3]
		
		# NbN_(a->sx[4],a->sy[4])ƌ_P(P1X,P1Y)̋߂B */
		PPH.sx[1] = Ck1X
		PPH.sy[1] = Ck1Y
		PPH.ex[1] = P1X
		PPH.ey[1] = P1Y
		pp(&PPH)
		L1 = PPH.l
		# NbN_(a->sx[4],a->sy[4])ƌ_Q(P2X,P2Y)̋߂B */
		PPH.sx[1] = Ck1X
		PPH.sy[1] = Ck1Y
		PPH.ex[1] = P2X
		PPH.ey[1] = P2Y
		pp(&PPH)
		L2 = PPH.l
		# ǂ̌_NbN_ɋ߂H */
		if (L1 < L2) {
			a->sx[2] = P1X
			a->sy[2] = P1Y
			a->sx[3] = 0
			a->sy[3] = 0
		}
		else if (L1 > L2) {
			a->sx[2] = P2X
			a->sy[2] = P2Y
			a->sx[3] = 0
			a->sy[3] = 0
		}
	}

	a->type = 1
	return 1
}



# -------------------------------------------------------------------
#  : Q~̌_(NbN_ɋ߂P_)
# ֐ : CCP1
#  : struct RtnDat *
# 	:	(a->cx[1] , a->cy[1]) a->r[1] (a->cx[2] , a->cy[2]) a->r[2]
# 	:	(a->sx[1] , a->sy[1]) (a->sx[2] , a->sy[2])    NbN_
# ߒl : int 0,1
# 	:	(a->sx[1] , a->sy[1])
# O : 
#  : 
int CCP1(struct RtnDat *a)
{
	struct RtnDat PPH
	double P1X, P1Y, P2X, P2Y, L1, L2, Ck1X, Ck1Y, Ck2X, Ck2Y


	# NbN_ */
	Ck1X = a->sx[1]
	Ck1Y = a->sy[1]
	Ck2X = a->sx[2]
	Ck2Y = a->sy[2]
	# _߂B */
	ccp(a)    # _(a->sx[1],a->sy[1])(a->sx[2],a->sy[2]) */

	# _ 0 ̂ƂB------------------------------ */
	if (a->type == 0) {
		a->sx[2] = 0
		a->sy[2] = 0
		return 0
	}
	# _ 1̂ƂB---------------------------- */
	else if (a->type == 1) return 1
	# _ 2̂ƂB---------------------------- */
	else if (a->type == 2) {
		# _Q P1(a->sx[2],a->sy[2]) P2(a->sx[3],a->sy[3]) */
		P1X = a->sx[1]
		P1Y = a->sy[1]
		P2X = a->sx[2]
		P2Y = a->sy[2]
		
		# NbN_(a->sx[4],a->sy[4])ƌ_P(P1X,P1Y)̋߂B */
		PPH.sx[1] = Ck1X
		PPH.sy[1] = Ck1Y
		PPH.ex[1] = P1X
		PPH.ey[1] = P1Y
		pp(&PPH)
		L1 = PPH.l
		# NbN_(a->sx[4],a->sy[4])ƌ_Q(P2X,P2Y)̋߂B */
		PPH.sx[1] = Ck2X
		PPH.sy[1] = Ck2Y
		PPH.ex[1] = P2X
		PPH.ey[1] = P2Y
		pp(&PPH)
		L2 = PPH.l
		# ǂ̌_NbN_ɋ߂H */
		if (L1 < L2) {
			a->sx[1] = P1X
			a->sy[1] = P1Y
		}
		else if (L1 > L2) {
			a->sx[1] = P2X
			a->sy[1] = P2Y
		}
	}
	a->sx[2] = 0
	a->sy[2] = 0
	a->type = 1
	return 1
}



# -------------------------------------------------------------------
#  : Q̎ۂ̌_
# ֐ : Act_llp
#  : RtnDat
# 	:	(sx[1] , sy[1]) (ex[1] , ey[1])
# 	:	(sx[2] , sy[2]) (ex[2] , ey[2])
# ߒl : int	 0:ۂ̌_Ȃ	 1:ۂ̌_)
# 	:	(sx[3] , sy[3]) , (type =
# O : 
#  : 
 */
int Act_llp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH, PPH
	double A1, A2
	double L1, L2


	dumy = *a

	llp(&dumy)
	# dumy.sx[3] , dumy.sy[3] */
	*a = dumy
	if (dumy.type == 0) return 0
	
	# =========================================================== */
	#  : ̊px										   */
	# =========================================================== */
	LAH.sx[1] = dumy.sx[1]
	LAH.sy[1] = dumy.sy[1]
	LAH.ex[1] = dumy.ex[1]
	LAH.ey[1] = dumy.ey[1]
	la(&LAH)
	A1 = LAH.Angle

	LAH.sx[1] = dumy.sx[1]
	LAH.sy[1] = dumy.sy[1]
	LAH.ex[1] = dumy.sx[3]
	LAH.ey[1] = dumy.sy[3]
	la(&LAH)
	if (sg(A1, 2) != sg(LAH.Angle, 2)) return 0


	LAH.sx[1] = dumy.sx[2]
	LAH.sy[1] = dumy.sy[2]
	LAH.ex[1] = dumy.ex[2]
	LAH.ey[1] = dumy.ey[2]
	la(&LAH)
	A2 = LAH.Angle

	LAH.sx[1] = dumy.sx[2]
	LAH.sy[1] = dumy.sy[2]
	LAH.ex[1] = dumy.sx[3]
	LAH.ey[1] = dumy.sy[3]
	la(&LAH)
	if (sg(A2, 2) != sg(LAH.Angle, 2)) return 0


	# =================================================== */
	#  : Q_Ԃ̋								   */
	# =================================================== */
	PPH.sx[1] = dumy.sx[1]
	PPH.sy[1] = dumy.sy[1]
	PPH.ex[1] = dumy.ex[1]
	PPH.ey[1] = dumy.ey[1]
	pp(&PPH)
	L1 = PPH.l

	PPH.sx[1] = dumy.sx[1]
	PPH.sy[1] = dumy.sy[1]
	PPH.ex[1] = dumy.sx[3]
	PPH.ey[1] = dumy.sy[3]
	pp(&PPH)
	if (L1 < PPH.l) return 0


	PPH.sx[1] = dumy.sx[2]
	PPH.sy[1] = dumy.sy[2]
	PPH.ex[1] = dumy.ex[2]
	PPH.ey[1] = dumy.ey[2]
	pp(&PPH)
	L2 = PPH.l

	PPH.sx[1] = dumy.sx[2]
	PPH.sy[1] = dumy.sy[2]
	PPH.ex[1] = dumy.sx[3]
	PPH.ey[1] = dumy.sy[3]
	pp(&PPH)
	if (L2 < PPH.l) return 0

	return 1
}



# -------------------------------------------------------------------
#  : Ɖ~ʂ̎ۂ̌_
# ֐ : Act_lcp
#  : RtnDat
# 	:	 1  (sx[1],sy[1]) - (ex[1],ey[1])
# 	:	~ 1  (cx[1],cy[1]) ,r[1], (sx[4],sy[4]) - (ex[4],ey[4])
# ߒl : RtnDat
# 	:	type   0 , 1 , 2
# 	:	_ 1  (sx[2],sy[2])
# 	:	_ 2  (sx[3],sy[3])
# O : 
#  : RtnDat diagram_plp,pph
 */
int Act_lcp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH, PPH
	double A1, L, SA, EA
	int Ret = 0, Ret1 = 0


	dumy = *a

	lcp(&dumy)
	# (dumy.sx[2] , dumy.sy[2]) */
	# (dumy.sx[3] , dumy.sy[3]) */
	*a = dumy

	if (dumy.type == 0) return Ret


	else if (dumy.type > 0) {
		if (sg(dumy.sx[1], COMPA_DIGITS) == sg(dumy.sx[2], COMPA_DIGITS) && sg(dumy.sy[1], COMPA_DIGITS) == sg(dumy.sy[2], COMPA_DIGITS))
			Ret1 = 1
		else {
			# --- < mF > ---------------------------------- */
			# =========================================================== */
			#  : ̊px										  */
			# =========================================================== */
			LAH.sx[1] = dumy.sx[1]
			LAH.sy[1] = dumy.sy[1]
			LAH.ex[1] = dumy.ex[1]
			LAH.ey[1] = dumy.ey[1]
			la(&LAH)
			A1 = LAH.Angle

			LAH.sx[1] = dumy.sx[1]
			LAH.sy[1] = dumy.sy[1]
			LAH.ex[1] = dumy.sx[2]
			LAH.ey[1] = dumy.sy[2]
			la(&LAH)
			
			if (A1+1 > LAH.Angle && A1-1 < LAH.Angle)
				Ret1 = 1
			else	
				Ret1 = 0
		}


		if (Ret1 == 1) {
			# =================================================== */
			#  : Q_Ԃ̋							  */
			# =================================================== */
			PPH.sx[1] = dumy.sx[1]
			PPH.sy[1] = dumy.sy[1]
			PPH.ex[1] = dumy.ex[1]
			PPH.ey[1] = dumy.ey[1]
			pp(&PPH)
			L = PPH.l

			PPH.sx[1] = dumy.sx[1]
			PPH.sy[1] = dumy.sy[1]
			PPH.ex[1] = dumy.sx[2]
			PPH.ey[1] = dumy.sy[2]
			pp(&PPH)
			if (sg(L, COMPA_DIGITS) < sg(PPH.l, COMPA_DIGITS))
				Ret1 = 0
			else
				Ret1 = 1
		}
		# --- < mF > ---------------------------------- */



		if (Ret1 == 1) {
			# --- < ~ʂmF > ---------------------------------- */
			# =========================================================== */
			#  : ̊px										  */
			# =========================================================== */
			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.sx[2]
			LAH.ey[1] = dumy.sy[2]
			la(&LAH)
			A1 = LAH.Angle

			# SA & EA߂B */
			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.sx[4]
			LAH.ey[1] = dumy.sy[4]
			la(&LAH)
			SA = LAH.Angle

			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.ex[4]
			LAH.ey[1] = dumy.ey[4]
			la(&LAH)
			EA = LAH.Angle
			if (SA == EA) {
				SA = 0
				EA = 360
			}

			# --- < _ 1  ~ʏɂ邩 > --- */
			if(SA < EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) && sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = 1
				else
					Ret = 0
			}
			else if(SA > EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = 1
				else
					Ret = 0
			}
			# --- < ~ʂmF > ---------------------------------- */
		}
	}



	Ret1 = 0
	if (dumy.type == 2) {
		if (sg(dumy.sx[1], COMPA_DIGITS) == sg(dumy.sx[3], COMPA_DIGITS) && sg(dumy.sy[1], COMPA_DIGITS) == sg(dumy.sy[3], COMPA_DIGITS))
			Ret1 = 1
		else {
			# --- < mF > ---------------------------------- */
			# =========================================================== */
			#  : ̊px										  */
			# =========================================================== */
			LAH.sx[1] = dumy.sx[1]
			LAH.sy[1] = dumy.sy[1]
			LAH.ex[1] = dumy.ex[1]
			LAH.ey[1] = dumy.ey[1]
			la(&LAH)
			A1 = LAH.Angle

			LAH.sx[1] = dumy.sx[1]
			LAH.sy[1] = dumy.sy[1]
			LAH.ex[1] = dumy.sx[3]
			LAH.ey[1] = dumy.sy[3]
			la(&LAH)
			if (A1+1 > LAH.Angle && A1-1 < LAH.Angle)
				Ret1 = 1
			else
				Ret1 = 0
		}

		if (Ret1 == 1) {
			# =================================================== */
			#  : Q_Ԃ̋							  */
			# =================================================== */
			PPH.sx[1] = dumy.sx[1]
			PPH.sy[1] = dumy.sy[1]
			PPH.ex[1] = dumy.ex[1]
			PPH.ey[1] = dumy.ey[1]
			pp(&PPH)
			L = PPH.l

			PPH.sx[1] = dumy.sx[1]
			PPH.sy[1] = dumy.sy[1]
			PPH.ex[1] = dumy.sx[3]
			PPH.ey[1] = dumy.sy[3]
			pp(&PPH)
			if (sg(L, COMPA_DIGITS) < sg(PPH.l, COMPA_DIGITS))
				Ret1 = 0
			else
				Ret1 = 1
		}
		# --- < mF > ---------------------------------- */



		if (Ret1 == 1) {
			# --- < ~ʂmF > --- */
			# =========================================================== */
			#  : ̊px										  */
			# =========================================================== */
			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.sx[3]
			LAH.ey[1] = dumy.sy[3]
			la(&LAH)
			A1 = LAH.Angle

			# SA & EA߂B */
			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.sx[4]
			LAH.ey[1] = dumy.sy[4]
			la(&LAH)
			SA = LAH.Angle

			LAH.sx[1] = dumy.cx[1]
			LAH.sy[1] = dumy.cy[1]
			LAH.ex[1] = dumy.ex[4]
			LAH.ey[1] = dumy.ey[4]
			la(&LAH)
			EA = LAH.Angle

			# --- < _ 1  ~ʏɂ邩 > --- */
			if(SA < EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) && sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS)) {
					if (Ret1 == 1) Ret = Ret + 2
				}
			}
			else if(SA > EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS)) {
					if (Ret1 == 1) Ret = Ret + 2
				}
			}
		}
	}

	return Ret
}



# -------------------------------------------------------------------
#  : Q~ʂ̎ۂ̌_
# ֐ : Act_ccp
#  : rtndat
# 	:	~ 1	  (cx[1] , cy[1]) , r[1], (sx[3] , sy[3]) - (ex[3] , ey[3])
# 	:	~ 2	  (cx[2] , cy[2]) , r[2], (sx[4] , sy[4]) - (ex[4] , ey[4])
# ߒl : rtndat
# 	:	type	   0 , 1 , 2
# 	:	_ 1	  (sx[1] , sy[1])
# 	:	_ 2	  (sx[2] , sy[2])
# O : 
#  : RtnDat pph,lah,paph,lcph,llah
 */
int Act_ccp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH
	double A1, SA, EA
	int Ret1 = 0, Ret = 0


	dumy = *a

	ccp(&dumy)
	# (dumy.sx[1] , dumy.sy[1]) */
	# (dumy.sx[2] , dumy.sy[2]) */

	# ccp() sƉ~ʂ̃f[^ւĂ肷̂ŁAȉ̏ */
	a->sx[1] = dumy.sx[1]
	a->sy[1] = dumy.sy[1]
	a->sx[2] = dumy.sx[2]
	a->sy[2] = dumy.sy[2]
	a->type = dumy.type
	dumy = *a


	if (dumy.type == 0) return Ret

	else if (dumy.type > 0) {
		# --- < ~ 1 mF > --- */
		# =========================================================== */
		#  : ̊px										  */
		# =========================================================== */
		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.sx[1]
		LAH.ey[1] = dumy.sy[1]
		la(&LAH)
		A1 = LAH.Angle

		# SA & EA߂B */
		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.sx[3]
		LAH.ey[1] = dumy.sy[3]
		la(&LAH)
		SA = LAH.Angle

		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.ex[3]
		LAH.ey[1] = dumy.ey[3]
		la(&LAH)
		EA = LAH.Angle

		# --- < _ 1  ~ʏɂ邩 > --- */
		if(SA < EA) {
			if( (A1 >= SA) && (A1 <= EA) )
				Ret1 = 1
			else
				Ret1 = 0
		}
		else if(SA > EA) {
			if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
				Ret1 = 1
			else
				Ret1 = 0
		}



		if (Ret1 == 1) {
			# --- < ~ 2 mF > --- */
			# =========================================================== */
			#  : ̊px										  */
			# =========================================================== */
			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.sx[1]
			LAH.ey[1] = dumy.sy[1]
			la(&LAH)
			A1 = LAH.Angle

			# SA & EA߂B */
			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.sx[4]
			LAH.ey[1] = dumy.sy[4]
			la(&LAH)
			SA = LAH.Angle

			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.ex[4]
			LAH.ey[1] = dumy.ey[4]
			la(&LAH)
			EA = LAH.Angle

			# --- < _ 1  ~ʏɂ邩 > --- */
			if(SA < EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) && sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = 1
			}
			else if(SA > EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = 1
			}
		}
	}



	Ret1 = 0
	if (dumy.type == 2) {
		# --- < ~ 1 mF > --- */
		# =========================================================== */
		#  : ̊px										  */
		# =========================================================== */
		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.sx[2]
		LAH.ey[1] = dumy.sy[2]
		la(&LAH)
		A1 = LAH.Angle

		# SA & EA߂ */
		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.sx[3]
		LAH.ey[1] = dumy.sy[3]
		la(&LAH)
		SA = LAH.Angle

		LAH.sx[1] = dumy.cx[1]
		LAH.sy[1] = dumy.cy[1]
		LAH.ex[1] = dumy.ex[3]
		LAH.ey[1] = dumy.ey[3]
		la(&LAH)
		EA = LAH.Angle

		# _ 2  ~ʏɂ邩 */
		if(SA < EA) {
			if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) && sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
				Ret1 = 1
			else
				Ret1 = 0
		}
		else if(SA > EA) {
			if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
				Ret1 = 1
			else
				Ret1 = 0
		}



		if (Ret1 == 1) {
			# ~ 2 mF */
			#  : ̊px */
			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.sx[2]
			LAH.ey[1] = dumy.sy[2]
			la(&LAH)
			A1 = LAH.Angle

			# SA & EA߂ */
			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.sx[4]
			LAH.ey[1] = dumy.sy[4]
			la(&LAH)
			SA = LAH.Angle

			LAH.sx[1] = dumy.cx[2]
			LAH.sy[1] = dumy.cy[2]
			LAH.ex[1] = dumy.ex[4]
			LAH.ey[1] = dumy.ey[4]
			la(&LAH)
			EA = LAH.Angle

			# _ 1  ~ʏɂ邩 */
			if(SA < EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) && sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = Ret + 2
			}
			else if(SA > EA) {
				if(sg(A1, COMPA_DIGITS) >= sg(SA, COMPA_DIGITS) || sg(A1, COMPA_DIGITS) <= sg(EA, COMPA_DIGITS))
					Ret = Ret + 2
			}
		}
	}
	return Ret
}



# -------------------------------------------------------------------
# f[^̓ւ
# -------------------------------------
# a  b ̃f[^ꊷ
# 
# -------------------------------------
# a	   : l
# b	   : l
# -------------------------------------------------------------------
 */
int Swap_double(double *a, double *b)
{
	double dumy

	dumy = *a
	*a = *b
	*b = dumy
	return 1
}



# -------------------------------------------------------------------
# l(_ȉ 3 )o͗p
# -------------------------------------
# dbl  ɂ str ĕԂ
# 
# -------------------------------------
# dbl	   : l
# str	   : ̃|C^ɌʂĕԂ
# Dot = 0 : ̏ꍇ_  
#    = 1 : ̏ꍇ_  L
# -------------------------------------------------------------------
 */
int FloatOut(char *str, double dbl, int Dot)
{
	int i = 1, j
	double dumy, dumy2, Dumy_dbl


	if (dbl < 0) {
		i = -1
		dbl = dbl# i
	}
	dbl = sg(dbl, 6)

	# 0 */
	Dumy_dbl = dbl
	dumy = floor(Dumy_dbl)
	dumy2 = Dumy_dbl - dumy
	if (dumy2 == 0) {
		if (Dot == 0) sprintf(str, "%d", (int)dbl*i)
		else		  sprintf(str, "%d.", (int)dbl*i)
		return 1
	}

	# 1-3 */
	for(j=1  j<=3  j++) {
		Dumy_dbl = dbl
		Dumy_dbl = Dumy_dbl * pow( 10, (double) j)  # pow ́A 10  j */
		dumy = floor( sg(Dumy_dbl, 3) )			 # floor ́Al̐؂̂ĂvZ */
		dumy2 = Dumy_dbl - dumy
		if (sg(dumy2, 3) == 0) {
			if (j == 1) 	 sprintf(str, "%.1f", dbl*i)
			else if (j == 2) sprintf(str, "%.2f", dbl*i)
			else if (j == 3) sprintf(str, "%.3f", dbl*i)
			else			 sprintf(str, "%.3f", dbl*i)
			return 1
		}
	}
	sprintf(str, "%.3f", dbl*i)
	return 1
}



# -------------------------------------------------------------------
# l(_ȉ 6 )o͗p
# -------------------------------------
# dbl  ɂ str ĕԂ
# 
# -------------------------------------
# dbl	   : l
# str	   : ̃|C^ɌʂĕԂ
# Dot = 0 : ̏ꍇ_  
#    = 1 : ̏ꍇ_  L
# -------------------------------------------------------------------
 */
int FloatOut6(char *str, double dbl, int Dot)
{
	int i = 1, j
	double dumy, dumy2, Dumy_dbl

	# -----------------------------------------------------
	# ܂`FbNA i ɕ
	 */
	if (dbl < 0) {
		i = -1
		dbl = dbl * i
	}
	# _ȉ 6 Ɏľܓ */
	dbl = sg(dbl, 6)

	# 0 */
	Dumy_dbl = dbl
	dumy = floor( sg(Dumy_dbl, 6) )  # _ȉ؂̂āAdumy  */
	dumy2 = Dumy_dbl - dumy		  # _ȉ݂̂߁Adumy2  */
	# _ȉ݂̂_ȉ 6 Ɏľܓ 0 ɂȂ΁A
	# ߂ĺAłB
	 */
	if (sg(dumy2, 6) == 0) {
		if (Dot == 0) sprintf(str, "%d", (int) dbl*i)
		else sprintf(str, "%d.", (int) dbl*i)
		return 1
	}

	# 1-6 */
	for(j=1  j<=6  j++) {
		Dumy_dbl = dbl
		Dumy_dbl = Dumy_dbl * pow( 10, (double) j)
		dumy = floor( sg(Dumy_dbl, 6) )
		dumy2 = Dumy_dbl - dumy
		if (sg(dumy2, 6) == 0) {
			if (j ==1 ) 	 sprintf(str, "%.1f", dbl*i)
			else if (j == 2) sprintf(str, "%.2f", dbl*i)
			else if (j == 3) sprintf(str, "%.3f", dbl*i)
			else if (j == 4) sprintf(str, "%.4f", dbl*i)
			else if (j == 5) sprintf(str, "%.5f", dbl*i)
			else			 sprintf(str, "%.6f", dbl*i)
			return 1
		}
	}
	sprintf(str, "%.6f", dbl*i)
	return 1
}


# -------------------------------------------------------------------
# l(_ȉ n )o͗p
# -------------------------------------
# dbl  ɂ str ĕԂ
# 
# -------------------------------------
# dbl	   : l
# str	   : ̃|C^ɌʂĕԂ
# n	   : ľܓŋ߂鏬_ȉ̌
# Dot = 0 : ̏ꍇ_	 
#    = 1 : ̏ꍇ_  L
# -------------------------------------------------------------------
 */
int FloatOut_n(char *str, double dbl, int n, int Dot)
{
	int i = 1, j
	double dumy, dumy2, Dumy_dbl
	char out_n[256]

	# -----------------------------------------------------
	# ܂`FbNA i ɕ
	 */
	if (dbl < 0) {
		i = -1
		dbl = dbl# i
	}
	# _ȉ n Ɏľܓ */
	dbl = sg(dbl, n)

	# -----------------------------------------------------
	# ǂ̃`FbN 0 
	 */
	Dumy_dbl = dbl
	dumy = floor( sg(Dumy_dbl, n) )  # _ȉ؂̂āAdumy  */
	dumy2 = Dumy_dbl - dumy		  # _ȉ݂̂߁Adumy2  */
	# _ȉ݂̂_ȉ n Ɏľܓ 0 ɂȂ΁A
	# ߂ĺAłB
	 */
	if (sg(dumy2, n) == 0) {
		if (Dot == 0) sprintf(str, "%d", (int) dbl*i)
		else sprintf(str, "%d.", (int) dbl*i)
		return 1
	}

	# -----------------------------------------------------
	# _ȉ`FbN 1-n	
	 */
	for(j = n-1  j >= 0  j--) {
		Dumy_dbl = dbl
		Dumy_dbl = Dumy_dbl * pow(10, (double) j)
		dumy = floor( sg(Dumy_dbl, n) )
		dumy2 = Dumy_dbl - dumy
		if (sg(dumy2, n) != 0) {
			sprintf(out_n, "%%.%df", j+1)
			sprintf(str, out_n, dbl*i)
			return 1
		}
	}

	return 0
}





# -------------------------------------------------------------------
# ]    _(px,py)  _(x,y) 𒆐S Angle x]ړ
 */
int rotation(double *px, double *py, double x, double y, double Angle)
{
	double RAD, DX, DY

	# ړxNg */
	RAD = degrad(Angle)

	DX = *px - x
	DY = *py - y
	*px = sg((DX * cos(RAD) - DY * sin(RAD)) + x, CALCU_DIGITS)
	*py = sg((DY * cos(RAD) + DX * sin(RAD)) + y, CALCU_DIGITS)

	return 1
}

# -------------------------------------------------------------------
# s    _(px,py)  xNg(x,y) ŕsړ
 */
int parallel(double *px, double *py, double x, double y)
{
	*px = sg(*px + x, CALCU_DIGITS)
	*py = sg(*py + y, CALCU_DIGITS)
	return 1
}

# -------------------------------------------------------------------
# Ώ    _(x,y)  (sx,sy)-(ex,ey) ɑ΂đΏ̈ړ
 */
int symmetry(double sx, double sy, double ex, double ey, double *x, double *y)
{
	struct RtnDat PLPH

	# -----------------------------------------------------
	# ɑ΂Ă̂ 
	PLPH.sx[1] = sx PLPH.sy[1] = sy PLPH.ex[1] = ex PLPH.ey[1] = ey
	PLPH.sx[2] = *x PLPH.sy[2] = *y
	plp(&PLPH)

	*x = sg(*x + 2 * (sg(PLPH.ex[2], CALCU_DIGITS) - sg(*x, CALCU_DIGITS)), CALCU_DIGITS)
	*y = sg(*y + 2 * (sg(PLPH.ey[2], CALCU_DIGITS) - sg(*y, CALCU_DIGITS)), CALCU_DIGITS)
	return 1
}

# -------------------------------------------------------------------
# XP[O    _(x,y)  _(x,y) 𒆐S k {}`ɕϊ
int scaling(double *px, double *py, double x, double y, double k)
{
	*px = sg((k * *px) + x * (1 - k), CALCU_DIGITS)
	*py = sg((k * *py) + y * (1 - k), CALCU_DIGITS)
	return 1
}





# ====================================================================
# ===	Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
# ====================================================================
#   Project			   : SagCAD
#   Source			   : Trace.c
# ====================================================================
 */





# -------------------------------------------------------------------
# px 0  360 ̊Ԃɂ
 */
int angle_check(double *angle)
{
	while (*angle < 0 || *angle > 360) {
		if (*angle > 360) *angle = *angle - 360
		if (*angle < 0) *angle = *angle + 360
	}
	return 1
}





# -------------------------------------------------------------------
# ľܓ _ȉw (20)
# 
# double : _f[^ 
# int	  : ۂ߂錅
 */
double sg(double value, int keta)
{
	int i = 1

	if (value < 0)
		i = -1
	value = value * (double) i
	value = (double) i * (floor( ( pow(10, keta) * value) + 0.5) ) / pow(10, keta)
	return value
}





# ====================================================================
# ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
# ====================================================================
#    Project              : SagCAD
#    Source               : diagram.rb
# ====================================================================





