/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */


#include "parallaction/parallaction.h"


namespace Parallaction {

byte Input::_resMouseArrow_NS[256] = {
	0x12, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x12, 0x11, 0x00, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x11, 0x00, 0x00, 0x00, 0x11, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* TODO: Scale this bitmap. Its 32x16, but the original scales it twice horizontally and 6 times
   vertically (64x96).

   TODO: The cursor data should be adjusted by adding 0x10 to each byte, because the bitmap
   must be drawn using the background palette.
*/
byte Input::_resMouseArrow_BR_Amiga[512] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

/*
	This palette snippet is used for animations in Big Red Adventure.
*/
byte braAmigaFramesDefaultPalette[48] = {
	0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0xFF, 0xE0, 0xCF, 0x7F, 0x7F, 0x7F, 0xD9, 0x9C, 0x84, 0x00,
	0x9E, 0xF0, 0x91, 0xCC, 0x36, 0xFF, 0x6A, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0x11, 0xB0, 0xEE,
	0xF0, 0xFF, 0x17, 0x3D, 0x18, 0xAC, 0x3A, 0xB0, 0x00, 0x00, 0x7D, 0x00, 0x00, 0xFF, 0xA8, 0xFF,
};


const char *callableNamesRes_ns[] = {
	"Projector",
	"HBOff",
	"StartIntro",
	"EndIntro",
	"MoveSheet",
	"Sketch",
	"Shade",
	"Score",
	"OffSound",
	"StartMusic",
	"CloseMusic",
	"Fade",
	"HBOn",
	"MoveSarc",
	"ContaFoglie",
	"ZeroFoglie",
	"Trasformata",
	"OffMouse",
	"OnMouse",
	"SetMask",
	"EndComment",
	"Frankenstain",
	"Finito",
	"Ridux",
	"TestResult"
};


const char *callableNamesRes_br[] = {
	"blufade",
	"resetpalette",
	"ferrcycle",
	"lipsinc",
	"albycle",
	"password"
};

const char *g_dinoName = "dino";
const char *g_donnaName = "donna";
const char *g_doughName = "dough";
const char *g_drkiName = "drki";

const char *g_minidinoName = "minidino";
const char *g_minidonnaName = "minidonna";
const char *g_minidoughName = "minidough";
const char *g_minidrkiName = "minidrki";

#define CALLABLE_NS(x) &Parallaction_ns::x

const Parallaction_ns::Callable Parallaction_ns::_dosCallables[] = {
	CALLABLE_NS(_c_play_boogie),
	CALLABLE_NS(_c_play_boogie),
	CALLABLE_NS(_c_startIntro),
	CALLABLE_NS(_c_endIntro),
	CALLABLE_NS(_c_moveSheet),
	CALLABLE_NS(_c_sketch),
	CALLABLE_NS(_c_shade),
	CALLABLE_NS(_c_score),
	CALLABLE_NS(_c_null),
	CALLABLE_NS(_c_null),
	CALLABLE_NS(_c_null),
	CALLABLE_NS(_c_fade),
	CALLABLE_NS(_c_play_boogie),
	CALLABLE_NS(_c_moveSarc),
	CALLABLE_NS(_c_contaFoglie),
	CALLABLE_NS(_c_zeroFoglie),
	CALLABLE_NS(_c_trasformata),
	CALLABLE_NS(_c_offMouse),
	CALLABLE_NS(_c_onMouse),
	CALLABLE_NS(_c_setMask),
	CALLABLE_NS(_c_endComment),
	CALLABLE_NS(_c_frankenstein),
	CALLABLE_NS(_c_finito),
	CALLABLE_NS(_c_ridux),
	CALLABLE_NS(_c_testResult)
};

const Parallaction_ns::Callable Parallaction_ns::_amigaCallables[] = {
	CALLABLE_NS(_c_projector),
	CALLABLE_NS(_c_HBOff),
	CALLABLE_NS(_c_startIntro),
	CALLABLE_NS(_c_endIntro),
	CALLABLE_NS(_c_moveSheet),
	CALLABLE_NS(_c_sketch),
	CALLABLE_NS(_c_shade),
	CALLABLE_NS(_c_score),
	CALLABLE_NS(_c_offSound),
	CALLABLE_NS(_c_startMusic),
	CALLABLE_NS(_c_closeMusic),
	CALLABLE_NS(_c_fade),
	CALLABLE_NS(_c_HBOn),
	CALLABLE_NS(_c_moveSarc),
	CALLABLE_NS(_c_contaFoglie),
	CALLABLE_NS(_c_zeroFoglie),
	CALLABLE_NS(_c_trasformata),
	CALLABLE_NS(_c_offMouse),
	CALLABLE_NS(_c_onMouse),
	CALLABLE_NS(_c_setMask),
	CALLABLE_NS(_c_endComment),
	CALLABLE_NS(_c_frankenstein),
	CALLABLE_NS(_c_finito),
	CALLABLE_NS(_c_ridux),
	CALLABLE_NS(_c_testResult)
};

#define CALLABLE_BR(x) &Parallaction_br::x

const Parallaction_br::Callable Parallaction_br::_dosCallables[] = {
	CALLABLE_BR(_c_blufade),
	CALLABLE_BR(_c_resetpalette),
	CALLABLE_BR(_c_ferrcycle),
	CALLABLE_BR(_c_lipsinc),
	CALLABLE_BR(_c_albcycle),
	CALLABLE_BR(_c_password)
};

const Parallaction_br::Callable Parallaction_br::_amigaCallables[] = {
	CALLABLE_BR(_c_blufade),
	CALLABLE_BR(_c_resetpalette),
	CALLABLE_BR(_c_null),
	CALLABLE_BR(_c_null),
	CALLABLE_BR(_c_null),
	CALLABLE_BR(_c_null)
};

void Parallaction_ns::initResources() {

	_callableNames = new Table(ARRAYSIZE(callableNamesRes_ns), callableNamesRes_ns);

	_localFlagNames = new FixedTable(NUM_LOCATIONS, 1);
	_localFlagNames->addData("visited");

	if (getPlatform() == Common::kPlatformDOS) {
		_callables = _dosCallables;
	} else {
		_callables = _amigaCallables;
	}

}

void Parallaction_br::initResources() {

	_callableNames = new Table(ARRAYSIZE(callableNamesRes_br), callableNamesRes_br);

	_localFlagNames = new FixedTable(NUM_LOCATIONS, 2);
	_localFlagNames->addData("visited");
	_localFlagNames->addData("testtrue");

	if (getPlatform() == Common::kPlatformDOS) {
		_callables = _dosCallables;
	} else {
		_callables = _amigaCallables;
	}

}

} // namespace Parallaction
