#ifndef INCLUDED_ENUMS_
#define INCLUDED_ENUMS_

static unsigned const END_AGE = 101;
static unsigned const MAX_AGE = END_AGE - 1;

enum VaryType
{
    VARY_MEAN,                  // every value is OK
    VARY_NONNEG,                   // varied values must be >= 0
    VARY_PROB                   // varied values must be probabilities
};

enum DistType                   // update Random::Sizes, Dostribution::s_name
{                               // when modified

    UNIFORM,                    // always used distributions
    UNIFORM_CASE,
    LOGNORMAL,

    N_STD_DISTRIBUTIONS,
 
    NORMAL_VARY = N_STD_DISTRIBUTIONS,

    UNIFORM_VARY,
    LOGNORMAL_VARY,

    N_DISTRIBUTIONS
};

enum GeneratorType
{
    FIXED_SEED,
    INCREASING_SEED,
    RANDOM_SEED,
};

enum ParamsSrc         
{
    CONFIGFILE,
    ANALYSIS,
    NONE,
};


#endif
