#define XERR
#include "modbase.ih"

void ModBase::specificityBase(AgeGroupVSDvect &dest, StringVect &keywords)
{
    keywords[2] = "Specificity:";
    keywords[3] = "ageGroup:";

    auto lines = Parser::any(keywords);

    if (not lines)                              // keywords not found
        return;

    unsigned count = 0;
    unsigned success = 0;

    while (auto line = lines.get())             // get all lines
    {
        AgeGroupVSD spec{ VARY_PROB, false };   // agegroupvsd w/o sd.

        istringstream in{ line->tail };     // prepare for extraction
        if (in >> spec)                     // extract the next specification
        {
            ++count;                        // got a specification

            if (not spec.ageGroup().nextRange(dest))    // check increasing
                break;                                  // age ranges

            dest.push_back(spec);           // OK
            ++success;
        }
    }

    if (success == 0 or count != success)
        Err::specification();
}


