#include <Wire.h> // подключаем библиотеку "Wire"
byte val = 0; // значение для передачи потенциометру

void setup() {
  Wire.begin();   // подключаемся к шине I2C как мастер
}

void loop() {
  Wire.beginTransmission(80); // начинаем обмен с устройством с I2C адресом "44" (0x2C)
  Wire.write(byte(0x00)); // посылаем инструкцию записи в регистр RDAC
  Wire.write(val); // задаём положение 128-позиционного потенциометра
  Wire.endTransmission(); // завершаем I2C передачу

  val++; // инкрементируем val на 1
  if (val == 127) { // по достижении максимума потенциометра
    val = 0; // сбрасываем val 
  }
  delay(100);
}