/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_49 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 20353, "epsg", 20353,
        "AGD84 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 53\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",135],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20353\"]]");
    p = add_epsg_def_ex (filter, first, last, 20354, "epsg", 20354,
        "AGD84 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 54\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",141],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20354\"]]");
    p = add_epsg_def_ex (filter, first, last, 20355, "epsg", 20355,
        "AGD84 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 55\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",147],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20355\"]]");
    p = add_epsg_def_ex (filter, first, last, 20356, "epsg", 20356,
        "AGD84 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 56\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",153],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20356\"]]");
    p = add_epsg_def_ex (filter, first, last, 20357, "epsg", 20357,
        "AGD84 / AMG zone 57 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 57 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",159],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20357\"]]");
    p = add_epsg_def_ex (filter, first, last, 20358, "epsg", 20358,
        "AGD84 / AMG zone 58 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 58 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",165],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20358\"]]");
    p = add_epsg_def_ex (filter, first, last, 20436, "epsg", 20436,
        "Ain el Abd / UTM zone 36N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 36N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20436\"]]");
    p = add_epsg_def_ex (filter, first, last, 20437, "epsg", 20437,
        "Ain el Abd / UTM zone 37N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 37N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",39],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20437\"]]");
    p = add_epsg_def_ex (filter, first, last, 20438, "epsg", 20438,
        "Ain el Abd / UTM zone 38N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 38N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",45],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20438\"]]");
    p = add_epsg_def_ex (filter, first, last, 20439, "epsg", 20439,
        "Ain el Abd / UTM zone 39N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 39N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",51],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20439\"]]");
    p = add_epsg_def_ex (filter, first, last, 20440, "epsg", 20440,
        "Ain el Abd / UTM zone 40N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 40N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",57],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20440\"]]");
    p = add_epsg_def_ex (filter, first, last, 20499, "epsg", 20499,
        "Ain el Abd / Bahrain Grid", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / Bahrain Grid\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4204\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",51],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20499\"]]");
    p = add_epsg_def_ex (filter, first, last, 20538, "epsg", 20538,
        "Afgooye / UTM zone 38N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 38N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"620");
    add_srs_wkt (p, 3,
        "5\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4205\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"20538\"]]");
    p = add_epsg_def_ex (filter, first, last, 20539, "epsg", 20539,
        "Afgooye / UTM zone 39N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 39N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"620");
    add_srs_wkt (p, 3,
        "5\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4205\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"20539\"]]");
    p = add_epsg_def_ex (filter, first, last, 20790, "epsg", 20790,
        "Lisbon (Lisbon) / Portuguese National Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "200000 +y_0=300000 +ellps=intl +towgs84=-304.046,-60.576");
    add_proj4text (p, 2,
        ",103.64,0,0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese National Grid\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"L");
    add_srs_wkt (p, 4,
        "isbon\",-9.13190611111111,AUTHORITY[\"EPSG\",\"8902\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4803\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.6");
    add_srs_wkt (p, 8,
        "666666666667],PARAMETER[\"central_meridian\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20790\"]]");
    p = add_epsg_def_ex (filter, first, last, 20791, "epsg", 20791,
        "Lisbon (Lisbon) / Portuguese Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,");
    add_proj4text (p, 2,
        "0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese Grid\",GEOGCS[\"Li");
    add_srs_wkt (p, 1,
        "sbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"Lisbon\",-");
    add_srs_wkt (p, 4,
        "9.13190611111111,AUTHORITY[\"EPSG\",\"8902\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4803\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",39.6666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"central_meridian\",1],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"20791\"]]");
    p = add_epsg_def_ex (filter, first, last, 20822, "epsg", 20822,
        "Aratu / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 22S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-51],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"20822\"]]");
    p = add_epsg_def_ex (filter, first, last, 20823, "epsg", 20823,
        "Aratu / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 23S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-45],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"20823\"]]");
    p = add_epsg_def_ex (filter, first, last, 20824, "epsg", 20824,
        "Aratu / UTM zone 24S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 24S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-39],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"20824\"]]");
    p = add_epsg_def_ex (filter, first, last, 20904, "epsg", 20904,
        "GSK-2011 / Gauss-Kruger zone 4", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 4\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",4500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20904\"]]");
    p = add_epsg_def_ex (filter, first, last, 20905, "epsg", 20905,
        "GSK-2011 / Gauss-Kruger zone 5", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 5\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20905\"]]");
    p = add_epsg_def_ex (filter, first, last, 20906, "epsg", 20906,
        "GSK-2011 / Gauss-Kruger zone 6", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 6\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",6500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20906\"]]");
    p = add_epsg_def_ex (filter, first, last, 20907, "epsg", 20907,
        "GSK-2011 / Gauss-Kruger zone 7", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 7\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20907\"]]");
    p = add_epsg_def_ex (filter, first, last, 20908, "epsg", 20908,
        "GSK-2011 / Gauss-Kruger zone 8", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 8\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",45],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20908\"]]");
    p = add_epsg_def_ex (filter, first, last, 20909, "epsg", 20909,
        "GSK-2011 / Gauss-Kruger zone 9", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 9\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",51],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",9500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"20909\"]]");
    p = add_epsg_def_ex (filter, first, last, 20910, "epsg", 20910,
        "GSK-2011 / Gauss-Kruger zone 10", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 10\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",57],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",10500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20910\"]]");
    p = add_epsg_def_ex (filter, first, last, 20911, "epsg", 20911,
        "GSK-2011 / Gauss-Kruger zone 11", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 11\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",63],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",11500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20911\"]]");
    p = add_epsg_def_ex (filter, first, last, 20912, "epsg", 20912,
        "GSK-2011 / Gauss-Kruger zone 12", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 12\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",69],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",12500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20912\"]]");
    p = add_epsg_def_ex (filter, first, last, 20913, "epsg", 20913,
        "GSK-2011 / Gauss-Kruger zone 13", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 13\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",75],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",13500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20913\"]]");
    p = add_epsg_def_ex (filter, first, last, 20914, "epsg", 20914,
        "GSK-2011 / Gauss-Kruger zone 14", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 14\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",81],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",14500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20914\"]]");
    p = add_epsg_def_ex (filter, first, last, 20915, "epsg", 20915,
        "GSK-2011 / Gauss-Kruger zone 15", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 15\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",87],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",15500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20915\"]]");
    p = add_epsg_def_ex (filter, first, last, 20916, "epsg", 20916,
        "GSK-2011 / Gauss-Kruger zone 16", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 16\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",93],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",16500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20916\"]]");
    p = add_epsg_def_ex (filter, first, last, 20917, "epsg", 20917,
        "GSK-2011 / Gauss-Kruger zone 17", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 17\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",99],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",17500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20917\"]]");
    p = add_epsg_def_ex (filter, first, last, 20918, "epsg", 20918,
        "GSK-2011 / Gauss-Kruger zone 18", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 18\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",105],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",18500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20918\"]]");
    p = add_epsg_def_ex (filter, first, last, 20919, "epsg", 20919,
        "GSK-2011 / Gauss-Kruger zone 19", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 19\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",111],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",19500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20919\"]]");
    p = add_epsg_def_ex (filter, first, last, 20920, "epsg", 20920,
        "GSK-2011 / Gauss-Kruger zone 20", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 20\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",117],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",20500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20920\"]]");
    p = add_epsg_def_ex (filter, first, last, 20921, "epsg", 20921,
        "GSK-2011 / Gauss-Kruger zone 21", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 21\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",123],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",21500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20921\"]]");
    p = add_epsg_def_ex (filter, first, last, 20922, "epsg", 20922,
        "GSK-2011 / Gauss-Kruger zone 22", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 22\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",129],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",22500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20922\"]]");
    p = add_epsg_def_ex (filter, first, last, 20923, "epsg", 20923,
        "GSK-2011 / Gauss-Kruger zone 23", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 23\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",135],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",23500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20923\"]]");
    p = add_epsg_def_ex (filter, first, last, 20924, "epsg", 20924,
        "GSK-2011 / Gauss-Kruger zone 24", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 24\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",141],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",24500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20924\"]]");
    p = add_epsg_def_ex (filter, first, last, 20925, "epsg", 20925,
        "GSK-2011 / Gauss-Kruger zone 25", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 25\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",147],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",25500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20925\"]]");
    p = add_epsg_def_ex (filter, first, last, 20926, "epsg", 20926,
        "GSK-2011 / Gauss-Kruger zone 26", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 26\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",153],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",26500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20926\"]]");
    p = add_epsg_def_ex (filter, first, last, 20927, "epsg", 20927,
        "GSK-2011 / Gauss-Kruger zone 27", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 27\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",159],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",27500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20927\"]]");
    p = add_epsg_def_ex (filter, first, last, 20928, "epsg", 20928,
        "GSK-2011 / Gauss-Kruger zone 28", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 28\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",165],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",28500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20928\"]]");
    p = add_epsg_def_ex (filter, first, last, 20929, "epsg", 20929,
        "GSK-2011 / Gauss-Kruger zone 29", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 29\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",29500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20929\"]]");
    p = add_epsg_def_ex (filter, first, last, 20930, "epsg", 20930,
        "GSK-2011 / Gauss-Kruger zone 30", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 30\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",177],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",30500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20930\"]]");
    p = add_epsg_def_ex (filter, first, last, 20931, "epsg", 20931,
        "GSK-2011 / Gauss-Kruger zone 31", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 31\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-177],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",31500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"20931\"]]");
    p = add_epsg_def_ex (filter, first, last, 20932, "epsg", 20932,
        "GSK-2011 / Gauss-Kruger zone 32", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger zone 32\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-171],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",32500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"20932\"]]");
    p = add_epsg_def_ex (filter, first, last, 20934, "epsg", 20934,
        "Arc 1950 / UTM zone 34S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 34S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4209\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",21],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"209");
    add_srs_wkt (p, 12,
        "34\"]]");
    p = add_epsg_def_ex (filter, first, last, 20935, "epsg", 20935,
        "Arc 1950 / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 35S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4209\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",27],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"209");
    add_srs_wkt (p, 12,
        "35\"]]");
    p = add_epsg_def_ex (filter, first, last, 20936, "epsg", 20936,
        "Arc 1950 / UTM zone 36S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 36S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4209\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"209");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 21004, "epsg", 21004,
        "GSK-2011 / Gauss-Kruger CM 21E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 21E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21004\"]]");
    p = add_epsg_def_ex (filter, first, last, 21005, "epsg", 21005,
        "GSK-2011 / Gauss-Kruger CM 27E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 27E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21005\"]]");
    p = add_epsg_def_ex (filter, first, last, 21006, "epsg", 21006,
        "GSK-2011 / Gauss-Kruger CM 33E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 33E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21006\"]]");
    p = add_epsg_def_ex (filter, first, last, 21007, "epsg", 21007,
        "GSK-2011 / Gauss-Kruger CM 39E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 39E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21007\"]]");
    p = add_epsg_def_ex (filter, first, last, 21008, "epsg", 21008,
        "GSK-2011 / Gauss-Kruger CM 45E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 45E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",45],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21008\"]]");
    p = add_epsg_def_ex (filter, first, last, 21009, "epsg", 21009,
        "GSK-2011 / Gauss-Kruger CM 51E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 51E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",51],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21009\"]]");
    p = add_epsg_def_ex (filter, first, last, 21010, "epsg", 21010,
        "GSK-2011 / Gauss-Kruger CM 57E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 57E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",57],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21010\"]]");
    p = add_epsg_def_ex (filter, first, last, 21011, "epsg", 21011,
        "GSK-2011 / Gauss-Kruger CM 63E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 63E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",63],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21011\"]]");
    p = add_epsg_def_ex (filter, first, last, 21012, "epsg", 21012,
        "GSK-2011 / Gauss-Kruger CM 69E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 69E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",69],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21012\"]]");
    p = add_epsg_def_ex (filter, first, last, 21013, "epsg", 21013,
        "GSK-2011 / Gauss-Kruger CM 75E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 75E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",75],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21013\"]]");
    p = add_epsg_def_ex (filter, first, last, 21014, "epsg", 21014,
        "GSK-2011 / Gauss-Kruger CM 81E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 81E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",81],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21014\"]]");
    p = add_epsg_def_ex (filter, first, last, 21015, "epsg", 21015,
        "GSK-2011 / Gauss-Kruger CM 87E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 87E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",87],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21015\"]]");
    p = add_epsg_def_ex (filter, first, last, 21016, "epsg", 21016,
        "GSK-2011 / Gauss-Kruger CM 93E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 93E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",93],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21016\"]]");
    p = add_epsg_def_ex (filter, first, last, 21017, "epsg", 21017,
        "GSK-2011 / Gauss-Kruger CM 99E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 99E\",GEOGCS[\"GSK-2");
    add_srs_wkt (p, 1,
        "011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",99],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"21017\"]]");
    p = add_epsg_def_ex (filter, first, last, 21018, "epsg", 21018,
        "GSK-2011 / Gauss-Kruger CM 105E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 105E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",105],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21018\"]]");
    p = add_epsg_def_ex (filter, first, last, 21019, "epsg", 21019,
        "GSK-2011 / Gauss-Kruger CM 111E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 111E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",111],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21019\"]]");
    p = add_epsg_def_ex (filter, first, last, 21020, "epsg", 21020,
        "GSK-2011 / Gauss-Kruger CM 117E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 117E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",117],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21020\"]]");
    p = add_epsg_def_ex (filter, first, last, 21021, "epsg", 21021,
        "GSK-2011 / Gauss-Kruger CM 123E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 123E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",123],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21021\"]]");
    p = add_epsg_def_ex (filter, first, last, 21022, "epsg", 21022,
        "GSK-2011 / Gauss-Kruger CM 129E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 129E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",129],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21022\"]]");
    p = add_epsg_def_ex (filter, first, last, 21023, "epsg", 21023,
        "GSK-2011 / Gauss-Kruger CM 135E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 135E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",135],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21023\"]]");
    p = add_epsg_def_ex (filter, first, last, 21024, "epsg", 21024,
        "GSK-2011 / Gauss-Kruger CM 141E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 141E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",141],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21024\"]]");
    p = add_epsg_def_ex (filter, first, last, 21025, "epsg", 21025,
        "GSK-2011 / Gauss-Kruger CM 147E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 147E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",147],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21025\"]]");
    p = add_epsg_def_ex (filter, first, last, 21026, "epsg", 21026,
        "GSK-2011 / Gauss-Kruger CM 153E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 153E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",153],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21026\"]]");
    p = add_epsg_def_ex (filter, first, last, 21027, "epsg", 21027,
        "GSK-2011 / Gauss-Kruger CM 159E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 159E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",159],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21027\"]]");
    p = add_epsg_def_ex (filter, first, last, 21028, "epsg", 21028,
        "GSK-2011 / Gauss-Kruger CM 165E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 165E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",165],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21028\"]]");
    p = add_epsg_def_ex (filter, first, last, 21029, "epsg", 21029,
        "GSK-2011 / Gauss-Kruger CM 171E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 171E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21029\"]]");
    p = add_epsg_def_ex (filter, first, last, 21030, "epsg", 21030,
        "GSK-2011 / Gauss-Kruger CM 177E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 177E\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",177],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"21030\"]]");
    p = add_epsg_def_ex (filter, first, last, 21031, "epsg", 21031,
        "GSK-2011 / Gauss-Kruger CM 177W", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 177W\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-177],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21031\"]]");
    p = add_epsg_def_ex (filter, first, last, 21032, "epsg", 21032,
        "GSK-2011 / Gauss-Kruger CM 171W", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / Gauss-Kruger CM 171W\",GEOGCS[\"GSK-");
    add_srs_wkt (p, 1,
        "2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-171],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21032\"]]");
    p = add_epsg_def_ex (filter, first, last, 21035, "epsg", 21035,
        "Arc 1960 / UTM zone 35S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21035\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21036, "epsg", 21036,
        "Arc 1960 / UTM zone 36S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21036\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21037, "epsg", 21037,
        "Arc 1960 / UTM zone 37S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21037\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21095, "epsg", 21095,
        "Arc 1960 / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21095\"]]");
    p = add_epsg_def_ex (filter, first, last, 21096, "epsg", 21096,
        "Arc 1960 / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21096\"]]");
    p = add_epsg_def_ex (filter, first, last, 21097, "epsg", 21097,
        "Arc 1960 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21097\"]]");
    p = add_epsg_def_ex (filter, first, last, 21100, "epsg", 21100,
        "Batavia (Jakarta) / NEIEZ (deprecated)", 0, 0,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia (Jakarta) / NEIEZ (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6813\"]],PRIMEM[\"J");
    add_srs_wkt (p, 4,
        "akarta\",106.807719444444,AUTHORITY[\"EPSG\",\"8908\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4813\"]],PROJECTION[\"Merc");
    add_srs_wkt (p, 7,
        "ator_1SP\"],PARAMETER[\"central_meridian\",110],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.997],PARAMETER[\"false_easting\",39");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",900000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21100\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 21148, "epsg", 21148,
        "Batavia / UTM zone 48S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 48S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21148\"]]");
    p = add_epsg_def_ex (filter, first, last, 21149, "epsg", 21149,
        "Batavia / UTM zone 49S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 49S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21149\"]]");
    p = add_epsg_def_ex (filter, first, last, 21150, "epsg", 21150,
        "Batavia / UTM zone 50S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 50S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21150\"]]");
    p = add_epsg_def_ex (filter, first, last, 21207, "epsg", 21207,
        "GSK-2011 / GSK 3GK zone 7", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 7\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",7250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21207\"]]");
    p = add_epsg_def_ex (filter, first, last, 21208, "epsg", 21208,
        "GSK-2011 / GSK 3GK zone 8", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 8\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",24],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",8250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21208\"]]");
    p = add_epsg_def_ex (filter, first, last, 21209, "epsg", 21209,
        "GSK-2011 / GSK 3GK zone 9", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 9\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",9250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21209\"]]");
    p = add_epsg_def_ex (filter, first, last, 21210, "epsg", 21210,
        "GSK-2011 / GSK 3GK zone 10", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 10\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",30],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",10250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21210\"]]");
    p = add_epsg_def_ex (filter, first, last, 21211, "epsg", 21211,
        "GSK-2011 / GSK 3GK zone 11", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 11\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",33],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",11250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21211\"]]");
    p = add_epsg_def_ex (filter, first, last, 21212, "epsg", 21212,
        "GSK-2011 / GSK 3GK zone 12", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 12\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",36],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",12250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21212\"]]");
    p = add_epsg_def_ex (filter, first, last, 21213, "epsg", 21213,
        "GSK-2011 / GSK 3GK zone 13", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 13\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",39],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",13250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21213\"]]");
    p = add_epsg_def_ex (filter, first, last, 21214, "epsg", 21214,
        "GSK-2011 / GSK 3GK zone 14", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 14\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",42],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",14250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21214\"]]");
    p = add_epsg_def_ex (filter, first, last, 21215, "epsg", 21215,
        "GSK-2011 / GSK 3GK zone 15", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 15\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",15250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21215\"]]");
    p = add_epsg_def_ex (filter, first, last, 21216, "epsg", 21216,
        "GSK-2011 / GSK 3GK zone 16", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 16\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",48],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",16250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21216\"]]");
    p = add_epsg_def_ex (filter, first, last, 21217, "epsg", 21217,
        "GSK-2011 / GSK 3GK zone 17", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 17\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",51],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",17250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21217\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

