/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTWIZARD_H
#define _SC_PROJECTWIZARD_H

// qt
#include <QtGui/QWizard>

/**
 * Project setup wizard.
 */
class ProjectWizard : public QWizard
{
  typedef QWizard super;
  Q_OBJECT;

public:
  ProjectWizard( QWidget *parent = 0 );
  ~ProjectWizard();

  QString getProjectName() const;
  QString getTrunkName() const;
  QString getTrunkUrl() const;
  QString getBranchesName() const;
  QString getBranchesUrl() const;
  QString getTagsName() const;
  QString getTagsUrl() const;
  QString getWcName() const;
  QString getWcPath() const;

private slots:
  /** page 2 */
  void selectPath();

  /** page 3 */
  void trunkFromWc();

  /* page 4 */
  void standardLayout();
};

#endif // _SC_PROJECTWIZARD_H
