
import swiginac
from swiginac import *

def tr(A):
    return sum(A[i,i] for i in range(3))

def inner(A, B):
    return sum(A[i,j]*B[i,j] for i in range(3) for j in range(3))

def diff(f, v):
    if isinstance(v, matrix):
        assert not isinstance(f, matrix)
        return matrix(3, 3, [swiginac.diff(f, v[i,j]) for i in range(3) for j in range(3)])
    return swiginac.diff(f, v)

def subs(f, s, v):
    assert isinstance(s, matrix)
    assert isinstance(v, matrix)
    repmap = exmap()
    for i in range(3):
        for j in range(3):
            repmap[s[i,j]] = v[i,j]
    return f.subs(repmap)

# --- Derivation of manufactured analytical solution:

# Some useful symbols
x = matrix(3,1, [symbol("x[%d]" % i) for i in range(3)])

lamda = symbol("lamda")
mu = symbol("mu")

# Picking an arbitrary divergence free solution
a = symbol("a")

# Problems (possibly a bad choice):
#u = matrix(3, 1, [a*(sin(x[1]) - x[1]),
#                  a*(sin(x[2]) - x[2]),
#                  a*(sin(x[0]) - x[0])])

# OK (with a=0.01):
#u = matrix(3, 1, [a*x[0],
#                  0.0,
#                  0.0])

# Testing now:
u = matrix(3, 1, [a*x[0],
                  a*x[1],
                  a*x[2]])

div_u = sum(diff(u[i], x[i]) for i in range(3))
if not div_u.expand().evalf() == 0:
    print "WARNING: div(u) =", div_u

# Want to compute g!

# Compute value of E 
I = matrix(3, 3, [1,0,0, 0,1,0, 0,0,1])
DuT = matrix(3,3, [diff(u[i], x[j]) for i in range(3) for j in range(3)])
F = I + DuT
FT = transpose(F)
J = determinant(F)
C = FT*F
Evalue = (C - I) / 2

# Compute psi(E)
E = symbolic_matrix(3, 3, "E")
psi = lamda/2 * tr(E)**2 + mu * inner(E, E)

# Second Piola-Kirchoff stress tensor
S = diff(psi, E)

# Substitute value of E into S
S = subs(S, E, Evalue)

# First Piola-Kirchoff stress tensor
P = F*S

# Compute g using strong form of equation # FIXME: Signs!
#g = u - div P
divP = matrix(3, 1, [sum(diff(P[i,j], x[i]) for i in range(3)) for j in range(3)])
g = u - divP

# Print solutions
def p(x):
    #x = swiginac.normal(x)
    #x = x.evalf()
    return x.printc()
print
print "u:"
print "        values[0] = %s;" % p(u[0])
print "        values[1] = %s;" % p(u[1])
print "        values[2] = %s;" % p(u[2])
print
print "g:"
print "        values[0] = %s;" % p(g[0])
print "        values[1] = %s;" % p(g[1])
print "        values[2] = %s;" % p(g[2])
print

