/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.nodes;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.piccolo2d.nodes.PShape;

public final class PArea
extends PShape {
    private final transient Area area;

    public PArea() {
        this.area = new Area();
    }

    public PArea(Stroke stroke) {
        this.area = new Area();
        this.setStroke(stroke);
    }

    public PArea(Shape shape) {
        if (shape == null) {
            throw new NullPointerException("shape must not be null");
        }
        this.area = new Area(shape);
    }

    public PArea(Shape shape, Stroke stroke) {
        if (shape == null) {
            throw new NullPointerException("shape must not be null");
        }
        this.area = new Area(shape);
        this.setStroke(stroke);
    }

    public PArea(Area area) {
        if (area == null) {
            throw new NullPointerException("area must not be null");
        }
        this.area = new Area();
        this.area.add(area);
    }

    public PArea(Area area, Stroke stroke) {
        if (area == null) {
            throw new NullPointerException("area must not be null");
        }
        this.area = new Area();
        this.area.add(area);
        this.setStroke(stroke);
    }

    public Area getArea() {
        return (Area)this.area.clone();
    }

    public Area getAreaReference() {
        return this.area;
    }

    public void add(Area area) {
        Area oldArea = (Area)this.area.clone();
        this.area.add(area);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "area", oldArea, this.getArea());
    }

    public void exclusiveOr(Area area) {
        Area oldArea = (Area)this.area.clone();
        this.area.exclusiveOr(area);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "area", oldArea, this.getArea());
    }

    public void intersect(Area area) {
        Area oldArea = (Area)this.area.clone();
        this.area.intersect(area);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "area", oldArea, this.getArea());
    }

    public void subtract(Area area) {
        Area oldArea = (Area)this.area.clone();
        this.area.subtract(area);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "area", oldArea, this.getArea());
    }

    public void reset() {
        Area oldArea = (Area)this.area.clone();
        this.area.reset();
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "area", oldArea, this.getArea());
    }

    public boolean isEmpty() {
        return this.area.isEmpty();
    }

    public boolean isPolygonal() {
        return this.area.isPolygonal();
    }

    public boolean isRectangular() {
        return this.area.isRectangular();
    }

    public boolean isSingular() {
        return this.area.isSingular();
    }

    protected Shape getShape() {
        return this.area;
    }

    protected void transform(AffineTransform transform) {
        this.area.transform(transform);
    }
}

