/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;
import org.piccolo2d.extras.swing.PViewport;
import org.piccolo2d.util.PBounds;

public class PScrollPaneLayout
extends ScrollPaneLayout {
    private static final long serialVersionUID = 1L;

    public void layoutContainer(Container parent) {
        boolean hsbNeeded;
        boolean vsbNeeded;
        Insets vpbInsets;
        Border viewportBorder;
        if (!(parent instanceof JScrollPane)) {
            throw new IllegalArgumentException("layoutContainer may only be applied to JScrollPanes");
        }
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = scrollPane.getBounds();
        availR.setLocation(0, 0);
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        boolean leftToRight = scrollPane.getComponentOrientation().isLeftToRight();
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = this.colHead.getPreferredSize().height;
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth;
            rowHeadR.width = rowHeadWidth = this.rowHead.getPreferredSize().width;
            availR.width -= rowHeadWidth;
            if (leftToRight) {
                rowHeadR.x = availR.x;
                availR.x += rowHeadWidth;
            } else {
                rowHeadR.x = availR.x + availR.width;
            }
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Dimension extentSize = this.getExtentSize(availR);
        PBounds cameraBounds = new PBounds(0.0, 0.0, extentSize.getWidth(), extentSize.getHeight());
        Dimension viewPrefSize = this.getViewSize(cameraBounds);
        Rectangle vsbR = new Rectangle(0, availR.y - vpbInsets.top, 0, 0);
        if (this.vsbPolicy == 22) {
            vsbNeeded = true;
        } else if (this.vsbPolicy == 21) {
            vsbNeeded = false;
        } else {
            boolean bl = vsbNeeded = viewPrefSize.height > extentSize.height;
        }
        if (this.vsb != null && vsbNeeded) {
            this.adjustForVSB(true, availR, vsbR, vpbInsets, leftToRight);
            extentSize = this.viewport.toViewCoordinates(availR.getSize());
            cameraBounds.setRect(0.0, 0.0, extentSize.getWidth(), extentSize.getHeight());
            viewPrefSize = ((PViewport)this.viewport).getViewSize((Rectangle2D)cameraBounds);
        }
        Rectangle hsbR = new Rectangle(availR.x - vpbInsets.left, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            hsbNeeded = true;
        } else if (this.hsbPolicy == 31) {
            hsbNeeded = false;
        } else {
            boolean bl = hsbNeeded = viewPrefSize.width > extentSize.width;
        }
        if (this.hsb != null && hsbNeeded) {
            this.adjustForHSB(true, availR, hsbR, vpbInsets);
            if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                cameraBounds.setRect(0.0, 0.0, extentSize.getWidth(), extentSize.getHeight());
                viewPrefSize = ((PViewport)this.viewport).getViewSize((Rectangle2D)cameraBounds);
                boolean bl = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (vsbNeeded) {
                    this.adjustForVSB(true, availR, vsbR, vpbInsets, leftToRight);
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
        }
        vsbR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        hsbR.width = availR.width + vpbInsets.left + vpbInsets.right;
        rowHeadR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        rowHeadR.y = availR.y - vpbInsets.top;
        colHeadR.width = availR.width + vpbInsets.left + vpbInsets.right;
        colHeadR.x = availR.x - vpbInsets.left;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rowHeadR);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(colHeadR);
        }
        if (this.vsb != null) {
            if (vsbNeeded) {
                this.vsb.setVisible(true);
                this.vsb.setBounds(vsbR);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (hsbNeeded) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(hsbR);
            } else {
                this.hsb.setVisible(false);
            }
        }
        if (this.lowerLeft != null) {
            if (leftToRight) {
                this.lowerLeft.setBounds(rowHeadR.x, hsbR.y, rowHeadR.width, hsbR.height);
            } else {
                this.lowerLeft.setBounds(vsbR.x, hsbR.y, vsbR.width, hsbR.height);
            }
        }
        if (this.lowerRight != null) {
            if (leftToRight) {
                this.lowerRight.setBounds(vsbR.x, hsbR.y, vsbR.width, hsbR.height);
            } else {
                this.lowerRight.setBounds(rowHeadR.x, hsbR.y, rowHeadR.width, hsbR.height);
            }
        }
        if (this.upperLeft != null) {
            if (leftToRight) {
                this.upperLeft.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
            } else {
                this.upperLeft.setBounds(vsbR.x, colHeadR.y, vsbR.width, colHeadR.height);
            }
        }
        if (this.upperRight != null) {
            if (leftToRight) {
                this.upperRight.setBounds(vsbR.x, colHeadR.y, vsbR.width, colHeadR.height);
            } else {
                this.upperRight.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
            }
        }
    }

    private Dimension getViewSize(PBounds cameraBounds) {
        Dimension viewPrefSize = this.viewport != null ? ((PViewport)this.viewport).getViewSize((Rectangle2D)cameraBounds) : new Dimension(0, 0);
        return viewPrefSize;
    }

    private Dimension getExtentSize(Rectangle availR) {
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        return extentSize;
    }

    protected void adjustForVSB(boolean wantsVSB, Rectangle available, Rectangle vsbR, Insets vpbInsets, boolean leftToRight) {
        int vsbWidth = this.vsb.getPreferredSize().width;
        if (wantsVSB) {
            available.width -= vsbWidth;
            vsbR.width = vsbWidth;
            if (leftToRight) {
                vsbR.x = available.x + available.width + vpbInsets.right;
            } else {
                vsbR.x = available.x - vpbInsets.left;
                available.x += vsbWidth;
            }
        } else {
            available.width += vsbWidth;
        }
    }

    protected void adjustForHSB(boolean wantsHSB, Rectangle available, Rectangle hsbR, Insets vpbInsets) {
        int hsbHeight = this.hsb.getPreferredSize().height;
        if (wantsHSB) {
            available.height -= hsbHeight;
            hsbR.y = available.y + available.height + vpbInsets.bottom;
            hsbR.height = hsbHeight;
        } else {
            available.height += hsbHeight;
        }
    }

    public static class UIResource
    extends PScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 1L;
    }
}

