/*
    Tucnak - VHF contest log
	Functions for WIN32 (MSVC, MINGW)
    Copyright (C) 2011 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#ifdef WIN32
#include "header.h"
#include <iphlpapi.h>
#include <io.h>


void sleep(int sec){
	Sleep(sec * 1000);
}

void usleep(int usec){
	Sleep(usec / 1000); // todo better resolution
}

int settimeofday(const struct timeval *tv, const void *zone){
	return 0;
}


void *sbrk(int increment){
	return NULL;
}
		


char *wokna(char *file){
	char *c;

	for (c = file; *c != '\0'; c++) if (*c == '/') *c = '\\';
	return file;
}

int pipe(int *fds){
	int port, master, ret;
    struct sockaddr_in sin;
    
	master = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (master == INVALID_SOCKET) {
        internal_("pipe: invalid master socket %d", WSAGetLastError());
        return -1;
    }

	for (port = 2000; port < 2500; port++){

		if (port == 2500 - 1){
			shutdown(master, SD_BOTH);
            internal_("pipe: no free socket");
			return -1;
		}
		sin.sin_family = AF_INET;
		sin.sin_addr.S_un.S_addr = inet_addr("127.0.0.1");
		sin.sin_port = htons(port);
		if (bind(master, (struct sockaddr *)&sin, sizeof(sin)) == SOCKET_ERROR){
			//if (WSAGetLastError() == WSAEADDRINUSE) continue;
			continue;
		}
		break;
	}

	if (listen(master, 5) == SOCKET_ERROR){
		shutdown(master, SD_BOTH);
        internal_("pipe: listen socket error");
		return -1;
	}

	fds[0] = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (fds[0] == INVALID_SOCKET){
		shutdown(master, SD_BOTH);
        internal_("pipe: invalid socket 0");
		return -1;
	}

	if (fcntl(fds[0], F_SETFL, O_NONBLOCK)){
		shutdown(master, SD_BOTH);
		shutdown(fds[0], SD_BOTH);
        internal_("pipe: can't set O_NONBLOCK");
		return -1;
	}

	if (connect(fds[0], (struct sockaddr*)&sin, sizeof(sin)) == SOCKET_ERROR){
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK){
			shutdown(master, SD_BOTH);
			shutdown(fds[0], SD_BOTH);
            internal_("pipe: can't connect");
			return -1;
		}
	}

	if (fcntl(fds[0], F_SETFL, 0)){
		shutdown(master, SD_BOTH);
		shutdown(fds[0], SD_BOTH);
        internal_("pipe: can't clear O_NONBLOCK");
		return -1;
	}

	fds[1] = accept(master, NULL, NULL);
	if (fds[1] == INVALID_SOCKET){
		shutdown(master, SD_BOTH);
		shutdown(fds[0], SD_BOTH);
        internal_("pipe: invalid socket accepted");
		return -1;
	}

	shutdown(master, SD_BOTH);	
	return 0;
}


int lockf(int fd, int cmd, off_t len){
	HANDLE h;
	
    //internal_("lockf neotestovna");
	h = (HANDLE)_get_osfhandle(fd);
	if (h == INVALID_HANDLE_VALUE) {
		errno = EBADF;
		return -1;
	}

	if (!LockFile(h, 0, 0, 0, 0)) {
		return -1;
	}

	if (cmd == F_TEST){
		UnlockFile(h, 0, 0, 0, 0);
	}
	return 0;// TODO
}

int fsync(int fd){
	return -1;
}


int tcgetattr(int fd, struct termios *termios_p){
	return -1;
}

int tcsetattr(int fd, int optional_actions, const struct termios *termios_p){
	return -1;
}

int tcflush(int fd, int queue_selector){
	return -1;
}

int cfsetispeed(struct termios *termios_p, speed_t speed){
	return -1;
}

int cfsetospeed(struct termios *termios_p, speed_t speed){
	return -1;
}
	
/* process */

pid_t fork(void){
	errno = 1;
	return (pid_t)-1;
}

int kill(pid_t pid, int sig){
	errno = 1;
	return -1;
}

pid_t waitpid(pid_t pid, int *status, int options){
	errno = 1;
	return -1;
}


/* signal */
int sigaction(int signum, const struct sigaction *act, struct sigaction *oldact){
	return -1;
}

int sigfillset(sigset_t *set){
	return -1;
}

/* interfaces */
typedef DWORD (CALLBACK *T_GetAdaptersInfo)(PIP_ADAPTER_INFO pAdapterInfo, PULONG pOutBufLen);

int get_interfaces(struct iface_struct *ifaces, int max_interfaces){
    PIP_ADAPTER_INFO pAdapterInfo;
	PIP_ADAPTER_INFO pAdapter;
	int i, j;
	T_GetAdaptersInfo p_GetAdaptersInfo = NULL;
	HMODULE iphlpapi = NULL;
	ULONG ulOutBufLen = sizeof (IP_ADAPTER_INFO);
	

	iphlpapi = LoadLibrary("iphlpapi.dll");
	if (!iphlpapi) return 0;
	
	p_GetAdaptersInfo = (T_GetAdaptersInfo) GetProcAddress(iphlpapi, "GetAdaptersInfo");
	if (!p_GetAdaptersInfo){
		FreeLibrary(iphlpapi);
		return 0;
	}

	pAdapterInfo = (IP_ADAPTER_INFO *) mem_alloc(sizeof (IP_ADAPTER_INFO));
	if (pAdapterInfo == NULL) {
		FreeLibrary(iphlpapi);
		return 0;
	}

	if (p_GetAdaptersInfo(pAdapterInfo, &ulOutBufLen) == ERROR_BUFFER_OVERFLOW) {
		mem_free(pAdapterInfo);
		pAdapterInfo = (IP_ADAPTER_INFO *) mem_alloc(ulOutBufLen);
		if (pAdapterInfo == NULL) {
			FreeLibrary(iphlpapi);
			return 0;
		}
	}

	if (p_GetAdaptersInfo(pAdapterInfo, &ulOutBufLen) != NO_ERROR) {
		mem_free(pAdapterInfo);
		FreeLibrary(iphlpapi);
		return 0;
	}

	FreeLibrary(iphlpapi);
	
	for (pAdapter = pAdapterInfo, i = 0; 
		pAdapter != NULL && i < max_interfaces; 
		pAdapter = pAdapter->Next, i++) {

		ifaces[i].ip.S_un.S_addr = inet_addr(pAdapter->IpAddressList.IpAddress.String);
		ifaces[i].netmask.S_un.S_addr = inet_addr(pAdapter->IpAddressList.IpMask.String);
		switch (pAdapter->Type){
			case MIB_IF_TYPE_OTHER:      sprintf(ifaces[i].name, "oth%d", i);  break;
			case MIB_IF_TYPE_ETHERNET:	 sprintf(ifaces[i].name, "eth%d", i); break;
			case MIB_IF_TYPE_TOKENRING:  sprintf(ifaces[i].name, "tr%d", i); break;
			case MIB_IF_TYPE_FDDI:       sprintf(ifaces[i].name, "fddi%d", i); break;
			case MIB_IF_TYPE_PPP:        sprintf(ifaces[i].name, "ppp%d", i); break;
			case MIB_IF_TYPE_LOOPBACK:   sprintf(ifaces[i].name, "lo"); break;
			case MIB_IF_TYPE_SLIP:       sprintf(ifaces[i].name, "sl%d", i); break;
			default: 			 	 	 sprintf(ifaces[i].name, "unk%d", i); break;
		}
	}

	return i;
}

/* fcntl */
int fcntl(int fd, int cmd, long arg){
	u_long iMode = 0;
	// If iMode = 0, blocking is enabled; 
    // If iMode != 0, non-blocking mode is enabled.
	if (cmd != F_SETFL) return -1;
	iMode = arg;
	if (ioctlsocket(fd, FIONBIO, &iMode) != NO_ERROR) return -1;
    return 0;
} 

/* ioctl */
int ioctl(int d, int request, ...){
	return -1;
}

/* sockets */
int inet_aton(const char *cp, struct in_addr *inp){
	unsigned long addr = inet_addr(cp);
	if (addr == INADDR_NONE) return 0; // invalid
	inp->S_un.S_addr = addr;
	return 1; // valid
	
}

/* os_dep.h */

static int get_e(char *env)
{
    char *v;
    if ((v = getenv(env))) return atoi(v);
    return 0;
}

void handle_terminal_resize(int fd, void (*fn)(cba_t))
{
/*#ifdef HAVE_SDL    
    if (sdl) return;
#endif
    install_signal_handler(SIGWINCH, sigwinch, (cba_t)(void*)fn, 0);*/
}

void unhandle_terminal_resize(int fd)
{
/*#ifdef HAVE_SDL    
    if (sdl) return;
#endif
    //install_signal_handler(SIGWINCH, NULL, CBA0, 0);*/
} 

int term_get_terminal_size(int fd, int *x, int *y)
{
    struct winsize ws;
    if (!x || !y) return -1;
    if (ioctl(1, TIOCGWINSZ, &ws) != -1) {
        if (!(*x = ws.ws_col) && !(*x = get_e("COLUMNS"))) *x = 80;
        if (!(*y = ws.ws_row) && !(*y = get_e("LINES"))) *y = 24;
        return 0;
    } else {
        !(*x = get_e("COLUMNS")) && (*x = 80);
        !(*y = get_e("LINES")) && (*y = 24);
    }
    return 0;
}

void terminate_osdep(void){
}



#endif /* win32 */
