/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.errordialog;

import fr.ove.utils.ByteVector;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;

public class PanelImage
extends Panel {
    private Image image;

    public PanelImage(String string) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            int n;
            ByteVector byteVector = new ByteVector();
            while ((n = inputStream.read()) != -1) {
                byteVector.addElement((byte)n);
                if (inputStream.available() != 0) continue;
            }
            this.image = Toolkit.getDefaultToolkit().createImage(byteVector.getBytes());
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Impossible to read image : IO problems");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Impossible to create image");
            exception.printStackTrace();
        }
        if (this.image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.out.print(interruptedException.toString());
            }
            if (mediaTracker.isErrorAny()) {
                throw new Exception("Impossible to load image");
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }
}

